/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.format.common;

import com.fasterxml.jackson.databind.JsonNode;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.eel.kitchen.jsonschema.format.FormatAttribute;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.util.NodeType;

public final class EmailFormatAttribute
extends FormatAttribute {
    private static final FormatAttribute instance = new EmailFormatAttribute();

    private EmailFormatAttribute() {
        super(NodeType.STRING, new NodeType[0]);
    }

    public static FormatAttribute getInstance() {
        return instance;
    }

    @Override
    public void checkValue(String fmt, ValidationReport report, JsonNode value) {
        try {
            new InternetAddress(value.textValue(), true);
        }
        catch (AddressException ignored) {
            Message.Builder msg = EmailFormatAttribute.newMsg(fmt).setMessage("string is not a valid email address").addInfo("value", value);
            report.addMessage(msg.build());
        }
    }
}

