/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.examples;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eel.kitchen.jsonschema.examples.ExampleBase;
import org.eel.kitchen.jsonschema.keyword.KeywordValidator;
import org.eel.kitchen.jsonschema.main.JsonSchema;
import org.eel.kitchen.jsonschema.main.JsonSchemaFactory;
import org.eel.kitchen.jsonschema.main.Keyword;
import org.eel.kitchen.jsonschema.metaschema.KeywordRegistries;
import org.eel.kitchen.jsonschema.metaschema.KeywordRegistry;
import org.eel.kitchen.jsonschema.metaschema.SchemaURIs;
import org.eel.kitchen.jsonschema.ref.JsonRef;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.syntax.SimpleSyntaxChecker;
import org.eel.kitchen.jsonschema.syntax.SyntaxChecker;
import org.eel.kitchen.jsonschema.util.NodeType;
import org.eel.kitchen.jsonschema.validator.ValidationContext;

public final class Example9
extends ExampleBase {
    public static void main(String ... args) throws IOException {
        JsonNode customSchema = Example9.loadResource("/custom-keyword.json");
        JsonNode good = Example9.loadResource("/custom-keyword-good.json");
        JsonNode bad = Example9.loadResource("/custom-keyword-bad.json");
        JsonRef ref = SchemaURIs.draftV4();
        KeywordRegistry registry = KeywordRegistries.draftV4();
        Keyword keyword = Keyword.withName("divisors").withSyntaxChecker(DivisorsSyntaxChecker.getInstance()).withValidatorClass(DivisorsKeywordValidator.class).build();
        registry.addKeyword(keyword);
        JsonSchemaFactory factory = new JsonSchemaFactory.Builder().addKeywordRegistry(ref, registry, false).build();
        JsonSchema schema = factory.fromSchema(customSchema);
        ValidationReport report = schema.validate(good);
        Example9.printReport(report);
        report = schema.validate(bad);
        Example9.printReport(report);
    }

    public static final class DivisorsKeywordValidator
    extends KeywordValidator {
        private final Set<BigInteger> divisors;

        public DivisorsKeywordValidator(JsonNode schema) {
            super("divisors", NodeType.INTEGER);
            ImmutableSet.Builder set = ImmutableSet.builder();
            for (JsonNode element : schema.get(this.keyword)) {
                set.add((Object)element.bigIntegerValue());
            }
            this.divisors = set.build();
        }

        @Override
        public void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
            BigInteger value = instance.bigIntegerValue();
            HashSet failed = Sets.newHashSet();
            for (BigInteger divisor : this.divisors) {
                if (value.mod(divisor).equals(BigInteger.ZERO)) continue;
                failed.add(divisor);
            }
            if (failed.isEmpty()) {
                return;
            }
            Message msg = this.newMsg().setMessage("integer value is not a multiple of all divisors").addInfo("divisors", Ordering.natural().sortedCopy(this.divisors)).addInfo("failed", Ordering.natural().sortedCopy((Iterable)failed)).build();
            report.addMessage(msg);
        }

        @Override
        public String toString() {
            return "divisors: " + Ordering.natural().sortedCopy(this.divisors);
        }
    }

    private static final class DivisorsSyntaxChecker
    extends SimpleSyntaxChecker {
        private static final SyntaxChecker instance = new DivisorsSyntaxChecker();

        public static SyntaxChecker getInstance() {
            return instance;
        }

        private DivisorsSyntaxChecker() {
            super("divisors", NodeType.ARRAY, new NodeType[0]);
        }

        @Override
        public void checkValue(Message.Builder msg, List<Message> messages, JsonNode schema) {
            JsonNode node = schema.get(this.keyword);
            int size = node.size();
            if (size == 0) {
                msg.setMessage("array must have at least one element");
                messages.add(msg.build());
                return;
            }
            HashSet set = Sets.newHashSet();
            for (int index = 0; index < size; ++index) {
                JsonNode element = node.get(index);
                NodeType type = NodeType.getNodeType(element);
                if (!set.add(element)) {
                    msg.clearInfo().setMessage("duplicate elements in array");
                    messages.add(msg.build());
                    return;
                }
                if (type == NodeType.INTEGER) continue;
                msg.setMessage("array element has incorrect type").addInfo("expected", NodeType.INTEGER).addInfo("index", index);
                messages.add(msg.build());
            }
        }
    }
}

