/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.examples;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.UUID;
import org.eel.kitchen.jsonschema.examples.ExampleBase;
import org.eel.kitchen.jsonschema.format.FormatAttribute;
import org.eel.kitchen.jsonschema.main.JsonSchema;
import org.eel.kitchen.jsonschema.main.JsonSchemaFactory;
import org.eel.kitchen.jsonschema.metaschema.KeywordRegistries;
import org.eel.kitchen.jsonschema.metaschema.KeywordRegistry;
import org.eel.kitchen.jsonschema.metaschema.SchemaURIs;
import org.eel.kitchen.jsonschema.ref.JsonRef;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.util.NodeType;

public final class Example8
extends ExampleBase {
    public static void main(String ... args) throws IOException {
        JsonNode customSchema = Example8.loadResource("/custom-fmt.json");
        JsonNode good = Example8.loadResource("/custom-fmt-good.json");
        JsonNode bad = Example8.loadResource("/custom-fmt-bad.json");
        JsonRef ref = SchemaURIs.draftV3();
        KeywordRegistry registry = KeywordRegistries.draftV3();
        registry.addFormatAttribute("uuid", UUIDFormatAttribute.getInstance());
        JsonSchemaFactory factory = new JsonSchemaFactory.Builder().addKeywordRegistry(ref, registry, true).build();
        JsonSchema schema = factory.fromSchema(customSchema);
        ValidationReport report = schema.validate(good);
        Example8.printReport(report);
        report = schema.validate(bad);
        Example8.printReport(report);
    }

    private static final class UUIDFormatAttribute
    extends FormatAttribute {
        private static final FormatAttribute instance = new UUIDFormatAttribute();

        private UUIDFormatAttribute() {
            super(NodeType.STRING, new NodeType[0]);
        }

        public static FormatAttribute getInstance() {
            return instance;
        }

        @Override
        public void checkValue(String fmt, ValidationReport report, JsonNode value) {
            try {
                UUID.fromString(value.textValue());
            }
            catch (IllegalArgumentException ignored) {
                Message.Builder msg = UUIDFormatAttribute.newMsg(fmt).addInfo("value", value).setMessage("string is not a valid UUID");
                report.addMessage(msg.build());
            }
        }
    }
}

