/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.format;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.net.InternetDomainName;
import org.eel.kitchen.jsonschema.format.FormatAttribute;
import org.eel.kitchen.jsonschema.main.ValidationFeature;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.util.NodeType;
import org.eel.kitchen.jsonschema.validator.ValidationContext;

public final class HostnameFormatAttribute
extends FormatAttribute {
    private static final FormatAttribute instance = new HostnameFormatAttribute();

    private HostnameFormatAttribute() {
        super(NodeType.STRING, new NodeType[0]);
    }

    public static FormatAttribute getInstance() {
        return instance;
    }

    @Override
    public void checkValue(String fmt, ValidationContext ctx, ValidationReport report, JsonNode value) {
        InternetDomainName hostname;
        Message.Builder msg = HostnameFormatAttribute.newMsg(fmt).setMessage("string is not a valid hostname").addInfo("value", value);
        try {
            hostname = InternetDomainName.from((String)value.textValue());
        }
        catch (IllegalArgumentException ignored) {
            report.addMessage(msg.build());
            return;
        }
        if (ctx.hasFeature(ValidationFeature.STRICT_RFC_CONFORMANCE)) {
            return;
        }
        if (!hostname.hasParent()) {
            report.addMessage(msg.build());
        }
    }
}

