/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.format;

import com.fasterxml.jackson.databind.JsonNode;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.eel.kitchen.jsonschema.format.FormatAttribute;
import org.eel.kitchen.jsonschema.main.ValidationFeature;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.util.NodeType;
import org.eel.kitchen.jsonschema.validator.ValidationContext;

public final class EmailFormatAttribute
extends FormatAttribute {
    private static final FormatAttribute instance = new EmailFormatAttribute();

    private EmailFormatAttribute() {
        super(NodeType.STRING, new NodeType[0]);
    }

    public static FormatAttribute getInstance() {
        return instance;
    }

    @Override
    public void checkValue(String fmt, ValidationContext ctx, ValidationReport report, JsonNode instance) {
        boolean strictRFC = ctx.hasFeature(ValidationFeature.STRICT_RFC_CONFORMANCE);
        try {
            new InternetAddress(instance.textValue(), !strictRFC);
        }
        catch (AddressException ignored) {
            Message.Builder msg = EmailFormatAttribute.newMsg(fmt).setMessage("string is not a valid email address").addInfo("value", instance);
            report.addMessage(msg.build());
        }
    }
}

