/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.report;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.eel.kitchen.jsonschema.main.JsonSchemaException;
import org.eel.kitchen.jsonschema.ref.JsonPointer;
import org.eel.kitchen.jsonschema.report.ValidationMessage;

public final class ValidationReport {
    private static final JsonPointer ROOT;
    private final ListMultimap<JsonPointer, ValidationMessage> msgMap = ArrayListMultimap.create();
    private JsonPointer path;
    private boolean fatal = false;

    public ValidationReport() {
        this(ROOT);
    }

    private ValidationReport(JsonPointer path) {
        this.path = path;
    }

    public JsonPointer getPath() {
        return this.path;
    }

    public void setPath(JsonPointer path) {
        this.path = path;
    }

    public boolean addMessage(ValidationMessage message) {
        if (this.fatal) {
            return true;
        }
        if (message.isFatal()) {
            this.fatal = true;
            this.msgMap.clear();
        }
        this.msgMap.put((Object)this.path, (Object)message);
        return this.fatal;
    }

    public void addMessages(Collection<ValidationMessage> messages) {
        for (ValidationMessage message : messages) {
            if (!this.addMessage(message)) continue;
            return;
        }
    }

    public int size() {
        return this.msgMap.size();
    }

    public boolean isSuccess() {
        return this.msgMap.isEmpty();
    }

    public boolean hasFatalError() {
        return this.fatal;
    }

    public void mergeWith(ValidationReport other) {
        if (this.fatal) {
            return;
        }
        if (other.fatal) {
            this.msgMap.clear();
            this.fatal = true;
        }
        this.msgMap.putAll(other.msgMap);
    }

    public ValidationReport copy() {
        return new ValidationReport(this.path);
    }

    public List<String> getMessages() {
        TreeSet paths = new TreeSet(this.msgMap.keySet());
        ImmutableList.Builder builder = ImmutableList.builder();
        for (JsonPointer path : paths) {
            for (ValidationMessage msg : this.msgMap.get((Object)path)) {
                builder.add((Object)(path + ": " + msg));
            }
        }
        return builder.build();
    }

    public JsonNode asJsonNode() {
        ObjectNode ret = JsonNodeFactory.instance.objectNode();
        for (JsonPointer ptr : this.msgMap.keySet()) {
            ArrayNode node = JsonNodeFactory.instance.arrayNode();
            for (ValidationMessage message : this.msgMap.get((Object)ptr)) {
                node.add(message.toJsonNode());
            }
            ret.put(ptr.toString(), (JsonNode)node);
        }
        return ret;
    }

    public String toString() {
        return "current path: \"" + this.path + "\"; " + this.msgMap.size() + " messages";
    }

    static {
        try {
            ROOT = new JsonPointer("");
        }
        catch (JsonSchemaException e) {
            throw new RuntimeException("WTF??", e);
        }
    }
}

