/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.util.Collections;
import java.util.EnumSet;
import org.eel.kitchen.jsonschema.report.ValidationDomain;
import org.eel.kitchen.jsonschema.report.ValidationMessage;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.util.NodeType;
import org.eel.kitchen.jsonschema.validator.ValidationContext;

public abstract class KeywordValidator {
    protected static final JsonNodeFactory nodeFactory = JsonNodeFactory.instance;
    protected final String keyword;
    private final EnumSet<NodeType> instanceTypes = EnumSet.noneOf(NodeType.class);

    protected KeywordValidator(String keyword, NodeType ... types) {
        this.keyword = keyword;
        Collections.addAll(this.instanceTypes, types);
    }

    public final void validateInstance(ValidationContext context, ValidationReport report, JsonNode instance) {
        if (this.instanceTypes.contains((Object)NodeType.getNodeType(instance))) {
            this.validate(context, report, instance);
        }
    }

    protected abstract void validate(ValidationContext var1, ValidationReport var2, JsonNode var3);

    protected final ValidationMessage.Builder newMsg() {
        return new ValidationMessage.Builder(ValidationDomain.VALIDATION).setKeyword(this.keyword);
    }

    public abstract String toString();
}

