/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.validator;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableMap;
import java.util.EnumSet;
import java.util.Map;
import org.eel.kitchen.jsonschema.format.FormatBundle;
import org.eel.kitchen.jsonschema.format.FormatSpecifier;
import org.eel.kitchen.jsonschema.main.ValidationFeature;
import org.eel.kitchen.jsonschema.ref.SchemaContainer;
import org.eel.kitchen.jsonschema.ref.SchemaNode;
import org.eel.kitchen.jsonschema.validator.JsonValidator;
import org.eel.kitchen.jsonschema.validator.JsonValidatorCache;

public final class ValidationContext {
    private final JsonValidatorCache cache;
    private SchemaContainer container;
    private final EnumSet<ValidationFeature> features;
    private final Map<String, FormatSpecifier> specifiers;

    public ValidationContext(JsonValidatorCache cache) {
        this(cache, EnumSet.noneOf(ValidationFeature.class), FormatBundle.defaultBundle());
    }

    public ValidationContext(JsonValidatorCache cache, EnumSet<ValidationFeature> features) {
        this(cache, features, FormatBundle.defaultBundle());
    }

    public ValidationContext(JsonValidatorCache cache, EnumSet<ValidationFeature> features, FormatBundle bundle) {
        this.cache = cache;
        this.features = EnumSet.copyOf(features);
        this.specifiers = ImmutableMap.copyOf(bundle.getSpecifiers());
    }

    public ValidationContext(JsonValidatorCache cache, SchemaContainer container) {
        this(cache, EnumSet.noneOf(ValidationFeature.class));
        this.container = container;
    }

    SchemaContainer getContainer() {
        return this.container;
    }

    void setContainer(SchemaContainer container) {
        this.container = container;
    }

    public boolean hasFeature(ValidationFeature feature) {
        return this.features.contains((Object)feature);
    }

    public FormatSpecifier getFormat(String fmt) {
        return this.specifiers.get(fmt);
    }

    public JsonValidator newValidator(JsonNode node) {
        SchemaNode schemaNode = new SchemaNode(this.container, node);
        return this.cache.getValidator(schemaNode);
    }

    public String toString() {
        return "current: " + this.container;
    }
}

