/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.main;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import java.util.EnumSet;
import org.eel.kitchen.jsonschema.bundle.Keyword;
import org.eel.kitchen.jsonschema.bundle.KeywordBundle;
import org.eel.kitchen.jsonschema.bundle.KeywordBundles;
import org.eel.kitchen.jsonschema.format.FormatBundle;
import org.eel.kitchen.jsonschema.format.FormatSpecifier;
import org.eel.kitchen.jsonschema.main.JsonSchema;
import org.eel.kitchen.jsonschema.main.JsonSchemaException;
import org.eel.kitchen.jsonschema.main.ValidationFeature;
import org.eel.kitchen.jsonschema.ref.SchemaContainer;
import org.eel.kitchen.jsonschema.ref.SchemaNode;
import org.eel.kitchen.jsonschema.ref.SchemaRegistry;
import org.eel.kitchen.jsonschema.uri.URIDownloader;
import org.eel.kitchen.jsonschema.uri.URIManager;
import org.eel.kitchen.jsonschema.validator.JsonValidatorCache;

public final class JsonSchemaFactory {
    private final SchemaRegistry registry;
    private final JsonValidatorCache cache;
    private final EnumSet<ValidationFeature> features;

    private JsonSchemaFactory(Builder builder) {
        this.registry = new SchemaRegistry(builder.uriManager, builder.namespace);
        this.cache = new JsonValidatorCache(builder.keywordBundle, this.registry);
        this.features = EnumSet.copyOf(builder.features);
    }

    public SchemaContainer registerSchema(JsonNode schema) {
        return this.registry.register(schema);
    }

    public SchemaContainer getSchema(URI uri) throws JsonSchemaException {
        return this.registry.get(uri);
    }

    public SchemaContainer getSchema(String str) throws JsonSchemaException {
        return this.registry.get(URI.create(str));
    }

    public JsonSchema createSchema(SchemaContainer container) {
        return this.createSchema(container, container.getSchema());
    }

    public JsonSchema createSchema(SchemaContainer container, String path) {
        ObjectNode node = JsonNodeFactory.instance.objectNode().put("$ref", path);
        return this.createSchema(container, (JsonNode)node);
    }

    private JsonSchema createSchema(SchemaContainer container, JsonNode schema) {
        SchemaNode schemaNode = new SchemaNode(container, schema);
        return new JsonSchema(this.cache, this.features, schemaNode);
    }

    public static final class Builder {
        private KeywordBundle keywordBundle = KeywordBundles.defaultBundle();
        private final URIManager uriManager = new URIManager();
        private URI namespace = URI.create("");
        private final EnumSet<ValidationFeature> features = EnumSet.noneOf(ValidationFeature.class);
        private FormatBundle formatBundle = FormatBundle.defaultBundle();

        public Builder registerScheme(String scheme, URIDownloader downloader) {
            this.uriManager.registerScheme(scheme, downloader);
            return this;
        }

        public Builder unregisterScheme(String scheme) {
            this.uriManager.unregisterScheme(scheme);
            return this;
        }

        public Builder registerKeyword(Keyword keyword) {
            this.keywordBundle.registerKeyword(keyword);
            return this;
        }

        public Builder unregisterKeyword(String name) {
            this.keywordBundle.unregisterKeyword(name);
            return this;
        }

        public Builder withKeywordBundle(KeywordBundle keywordBundle) {
            this.keywordBundle = keywordBundle;
            return this;
        }

        public Builder addKeywords(KeywordBundle keywordBundle) {
            this.keywordBundle.mergeWith(keywordBundle);
            return this;
        }

        public Builder setNamespace(String namespace) {
            this.namespace = URI.create(namespace);
            return this;
        }

        public Builder addRedirection(String from, String to) {
            this.uriManager.addRedirection(from, to);
            return this;
        }

        public Builder enableFeature(ValidationFeature feature) {
            this.features.add(feature);
            return this;
        }

        public Builder registerFormat(String fmt, FormatSpecifier specifier) {
            this.formatBundle.registerFormat(fmt, specifier);
            return this;
        }

        public Builder unregisterFormat(String fmt) {
            this.formatBundle.unregisterFormat(fmt);
            return this;
        }

        public Builder withFormatBundle(FormatBundle formatBundle) {
            this.formatBundle = formatBundle;
            return this;
        }

        public Builder addFormats(FormatBundle formatBundle) {
            this.formatBundle.mergeWith(formatBundle);
            return this;
        }

        public JsonSchemaFactory build() {
            return new JsonSchemaFactory(this);
        }
    }
}

