/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.validator;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.eel.kitchen.jsonschema.main.JsonSchemaFactory;
import org.eel.kitchen.jsonschema.main.SchemaContainer;
import org.eel.kitchen.jsonschema.main.ValidationContext;
import org.eel.kitchen.jsonschema.main.ValidationReport;
import org.eel.kitchen.jsonschema.ref.JsonPointer;
import org.eel.kitchen.jsonschema.validator.JsonValidator;
import org.eel.kitchen.jsonschema.validator.RefResolverJsonValidator;
import org.eel.kitchen.jsonschema.validator.SchemaNode;

public final class ArrayJsonValidator
extends JsonValidator {
    private final JsonNode additionalItems;
    private final List<JsonNode> items;

    ArrayJsonValidator(JsonSchemaFactory factory, SchemaNode schemaNode) {
        super(factory, schemaNode);
        JsonNode schema = schemaNode.getNode();
        JsonNode node = schema.path("items");
        if (node.isObject()) {
            this.additionalItems = node;
            this.items = Collections.emptyList();
            return;
        }
        this.items = ImmutableList.copyOf((Iterable)node);
        node = schema.path("additionalItems");
        this.additionalItems = node.isObject() ? node : EMPTY_SCHEMA;
    }

    @Override
    public boolean validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        SchemaContainer container = context.getContainer();
        JsonPointer pwd = report.getPath();
        for (int i = 0; i < instance.size(); ++i) {
            SchemaNode subSchema = this.getSchemaNode(container, i);
            JsonNode element = instance.get(i);
            report.setPath(pwd.append(i));
            JsonValidator validator = new RefResolverJsonValidator(this.factory, subSchema);
            while (((JsonValidator)validator).validate(context, report, element)) {
                validator = ((JsonValidator)validator).next();
            }
            context.setContainer(container);
        }
        report.setPath(pwd);
        return false;
    }

    @Override
    public JsonValidator next() {
        throw new IllegalStateException("I should not have been called");
    }

    private SchemaNode getSchemaNode(SchemaContainer container, int index) {
        JsonNode node = index >= this.items.size() ? this.additionalItems : this.items.get(index);
        return new SchemaNode(container, node);
    }
}

