/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.EnumSet;
import java.util.List;
import org.eel.kitchen.jsonschema.syntax.SimpleSyntaxChecker;
import org.eel.kitchen.jsonschema.util.NodeType;

public class ArrayChildrenSyntaxChecker
extends SimpleSyntaxChecker {
    private final EnumSet<NodeType> childrenTypes;

    protected ArrayChildrenSyntaxChecker(String keyword, EnumSet<NodeType> childrenTypes, NodeType type, NodeType ... types) {
        super(keyword, type, types);
        this.childrenTypes = EnumSet.copyOf(childrenTypes);
    }

    @Override
    final void checkValue(List<String> messages, JsonNode schema) {
        JsonNode node = schema.get(this.keyword);
        if (!node.isArray()) {
            return;
        }
        for (JsonNode value : node) {
            if (this.childrenTypes.contains((Object)NodeType.getNodeType(value))) continue;
            messages.add("wrong element type in array");
        }
    }
}

