/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.ref;

import com.fasterxml.jackson.databind.JsonNode;
import org.eel.kitchen.jsonschema.main.JsonSchemaException;
import org.eel.kitchen.jsonschema.ref.IdFragment;
import org.eel.kitchen.jsonschema.ref.JsonPointer;

public abstract class JsonFragment {
    private static final JsonFragment EMPTY = new JsonFragment(){

        @Override
        public JsonNode resolve(JsonNode node) {
            return node;
        }

        @Override
        public String toString() {
            return "";
        }
    };

    public static JsonFragment fromFragment(String fragment) {
        if (fragment.isEmpty()) {
            return EMPTY;
        }
        try {
            return new JsonPointer(fragment);
        }
        catch (JsonSchemaException ignored) {
            return new IdFragment(fragment);
        }
    }

    public abstract JsonNode resolve(JsonNode var1);

    public final boolean isEmpty() {
        return this == EMPTY;
    }

    public abstract String toString();
}

