/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.main;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import org.eel.kitchen.jsonschema.main.JsonSchemaException;
import org.eel.kitchen.jsonschema.main.SchemaContainer;
import org.eel.kitchen.jsonschema.ref.JsonRef;
import org.eel.kitchen.jsonschema.uri.URIManager;

public final class SchemaRegistry {
    private final URI namespace;
    private final LoadingCache<URI, SchemaContainer> cache;

    SchemaRegistry(final URIManager manager, URI namespace) {
        this.namespace = namespace.normalize();
        this.cache = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new CacheLoader<URI, SchemaContainer>(){

            public SchemaContainer load(URI key) throws JsonSchemaException {
                return new SchemaContainer(key, manager.getContent(key));
            }
        });
    }

    public SchemaContainer register(JsonNode schema) throws JsonSchemaException {
        Preconditions.checkNotNull((Object)schema, (Object)"cannot register null schema");
        SchemaContainer container = new SchemaContainer(schema);
        JsonRef ref = container.getLocator();
        if (ref.isAbsolute()) {
            this.cache.put((Object)ref.getRootAsURI(), (Object)container);
        }
        return container;
    }

    public SchemaContainer get(URI uri) throws JsonSchemaException {
        try {
            return (SchemaContainer)this.cache.get((Object)this.namespace.resolve(uri).normalize());
        }
        catch (ExecutionException e) {
            throw new JsonSchemaException(e.getCause().getMessage());
        }
    }
}

