/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.main;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import org.eel.kitchen.jsonschema.main.JsonSchemaException;
import org.eel.kitchen.jsonschema.ref.JsonRef;

public final class SchemaContainer {
    private final JsonNode schema;
    private final JsonRef locator;

    public SchemaContainer(JsonNode schema) {
        JsonRef ref;
        try {
            ref = JsonRef.fromNode(schema.path("id"));
        }
        catch (JsonSchemaException ignored) {
            this.locator = JsonRef.emptyRef();
            this.schema = schema;
            return;
        }
        if (!ref.isAbsolute()) {
            ref = JsonRef.emptyRef();
        }
        this.locator = ref;
        this.schema = SchemaContainer.cleanup(schema);
    }

    SchemaContainer(URI uri, JsonNode node) {
        this.locator = JsonRef.fromURI(uri);
        this.schema = SchemaContainer.cleanup(node);
    }

    public JsonRef getLocator() {
        return this.locator;
    }

    public JsonNode getSchema() {
        return this.schema;
    }

    private static JsonNode cleanup(JsonNode schema) {
        if (!schema.has("id")) {
            return schema;
        }
        ObjectNode ret = (ObjectNode)schema.deepCopy();
        ret.remove("id");
        return ret;
    }
}

