/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import org.eel.kitchen.jsonschema.keyword.AbstractTypeKeywordValidator;
import org.eel.kitchen.jsonschema.main.JsonSchemaFactory;
import org.eel.kitchen.jsonschema.main.SchemaContainer;
import org.eel.kitchen.jsonschema.main.ValidationContext;
import org.eel.kitchen.jsonschema.main.ValidationReport;
import org.eel.kitchen.jsonschema.util.NodeType;
import org.eel.kitchen.jsonschema.validator.JsonValidator;
import org.eel.kitchen.jsonschema.validator.RefResolverJsonValidator;
import org.eel.kitchen.jsonschema.validator.SchemaNode;

public final class TypeKeywordValidator
extends AbstractTypeKeywordValidator {
    public TypeKeywordValidator(JsonNode schema) {
        super("type", schema);
    }

    @Override
    public void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        if (this.typeSet.contains((Object)NodeType.getNodeType(instance))) {
            return;
        }
        ValidationReport typeReport = report.copy();
        typeReport.addMessage("instance does not match any allowed primitive type");
        SchemaContainer container = context.getContainer();
        JsonSchemaFactory factory = context.getFactory();
        for (JsonNode schema : this.schemas) {
            ValidationReport tempReport = report.copy();
            SchemaNode subNode = new SchemaNode(container, schema);
            JsonValidator validator = new RefResolverJsonValidator(factory, subNode);
            while (((JsonValidator)validator).validate(context, tempReport, instance)) {
                validator = ((JsonValidator)validator).next();
            }
            context.setContainer(container);
            if (tempReport.isSuccess()) {
                return;
            }
            typeReport.mergeWith(tempReport);
        }
        report.mergeWith(typeReport);
    }
}

