/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import org.eel.kitchen.jsonschema.keyword.KeywordValidator;
import org.eel.kitchen.jsonschema.main.ValidationContext;
import org.eel.kitchen.jsonschema.main.ValidationReport;
import org.eel.kitchen.jsonschema.util.NodeType;
import org.eel.kitchen.jsonschema.util.RhinoHelper;

public final class PatternKeywordValidator
extends KeywordValidator {
    private final String regex;

    public PatternKeywordValidator(JsonNode schema) {
        super("pattern", NodeType.STRING);
        this.regex = schema.get(this.keyword).textValue();
    }

    @Override
    public void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        if (!RhinoHelper.regMatch(this.regex, instance.textValue())) {
            report.addMessage("instance does not match regex");
        }
    }

    @Override
    public String toString() {
        return this.keyword + ": " + this.regex;
    }
}

