/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eel.kitchen.jsonschema.keyword.KeywordValidator;
import org.eel.kitchen.jsonschema.main.JsonSchemaFactory;
import org.eel.kitchen.jsonschema.main.SchemaContainer;
import org.eel.kitchen.jsonschema.main.ValidationContext;
import org.eel.kitchen.jsonschema.main.ValidationReport;
import org.eel.kitchen.jsonschema.util.JacksonUtils;
import org.eel.kitchen.jsonschema.util.NodeType;
import org.eel.kitchen.jsonschema.validator.JsonValidator;
import org.eel.kitchen.jsonschema.validator.RefResolverJsonValidator;
import org.eel.kitchen.jsonschema.validator.SchemaNode;

public final class DependenciesKeywordValidator
extends KeywordValidator {
    private static final Joiner DEP_JOINER = Joiner.on((String)"; ").skipNulls();
    private final SetMultimap<String, String> simple;
    private final Map<String, JsonNode> schemas;

    public DependenciesKeywordValidator(JsonNode schema) {
        super("dependencies", NodeType.OBJECT);
        Map<String, JsonNode> fields = JacksonUtils.nodeToMap(schema.get("dependencies"));
        ImmutableMap.Builder schemaBuilder = new ImmutableMap.Builder();
        ImmutableSetMultimap.Builder simpleBuilder = new ImmutableSetMultimap.Builder();
        for (Map.Entry<String, JsonNode> entry : fields.entrySet()) {
            String key = entry.getKey();
            JsonNode value = entry.getValue();
            if (value.isObject()) {
                schemaBuilder.put((Object)key, (Object)value);
                continue;
            }
            if (value.size() == 0) {
                simpleBuilder.put((Object)key, (Object)value.textValue());
                continue;
            }
            for (JsonNode element : value) {
                simpleBuilder.put((Object)key, (Object)element.textValue());
            }
        }
        this.schemas = schemaBuilder.build();
        this.simple = simpleBuilder.build();
    }

    @Override
    public void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        Set<String> fields = JacksonUtils.fieldNames(instance);
        HashSet neededFields = new HashSet();
        for (String field : fields) {
            neededFields.addAll(this.simple.get((Object)field));
        }
        if (!fields.containsAll(neededFields)) {
            report.addMessage("missing property dependencies");
        }
        HashMap<String, JsonNode> schemaDeps = new HashMap<String, JsonNode>(this.schemas);
        schemaDeps.keySet().retainAll(fields);
        SchemaContainer container = context.getContainer();
        JsonSchemaFactory factory = context.getFactory();
        for (JsonNode subSchema : schemaDeps.values()) {
            SchemaNode subNode = new SchemaNode(container, subSchema);
            JsonValidator validator = new RefResolverJsonValidator(factory, subNode);
            while (((JsonValidator)validator).validate(context, report, instance)) {
                validator = ((JsonValidator)validator).next();
            }
            context.setContainer(container);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.keyword).append(": ");
        if (this.simple.isEmpty() && this.schemas.isEmpty()) {
            return sb.append("none??").toString();
        }
        DEP_JOINER.appendTo(sb, this.simple.isEmpty() ? null : this.simple, (Object)this.schemasToString(), new Object[0]);
        return sb.toString();
    }

    private String schemasToString() {
        if (this.schemas.isEmpty()) {
            return null;
        }
        return "further schema validations for properties " + this.schemas.keySet();
    }
}

