/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.format;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.eel.kitchen.jsonschema.format.FormatSpecifier;
import org.eel.kitchen.jsonschema.util.NodeType;

public final class URIFormatSpecifier
extends FormatSpecifier {
    private static final FormatSpecifier instance = new URIFormatSpecifier();

    private URIFormatSpecifier() {
        super(NodeType.STRING, new NodeType[0]);
    }

    public static FormatSpecifier getInstance() {
        return instance;
    }

    @Override
    void checkValue(List<String> messages, JsonNode value) {
        try {
            new URI(value.textValue());
        }
        catch (URISyntaxException ignored) {
            messages.add("string is not a valid URI");
        }
    }
}

