/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.format;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.net.InternetDomainName;
import java.util.List;
import org.eel.kitchen.jsonschema.format.FormatSpecifier;
import org.eel.kitchen.jsonschema.util.NodeType;

public final class HostnameFormatSpecifier
extends FormatSpecifier {
    private static final FormatSpecifier instance = new HostnameFormatSpecifier();

    private HostnameFormatSpecifier() {
        super(NodeType.STRING, new NodeType[0]);
    }

    public static FormatSpecifier getInstance() {
        return instance;
    }

    @Override
    void checkValue(List<String> messages, JsonNode value) {
        try {
            if (!InternetDomainName.from((String)value.textValue()).hasParent()) {
                messages.add("string is not a valid hostname");
            }
        }
        catch (IllegalArgumentException ignored) {
            messages.add("string is not a valid hostname");
        }
    }
}

