/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.bundle;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.eel.kitchen.jsonschema.bundle.Keyword;
import org.eel.kitchen.jsonschema.keyword.KeywordValidator;
import org.eel.kitchen.jsonschema.syntax.SyntaxChecker;

public final class KeywordBundle {
    private final Map<String, SyntaxChecker> syntaxCheckers = new HashMap<String, SyntaxChecker>();
    private final Map<String, Class<? extends KeywordValidator>> validators = new HashMap<String, Class<? extends KeywordValidator>>();

    KeywordBundle copy() {
        KeywordBundle ret = new KeywordBundle();
        ret.syntaxCheckers.putAll(this.syntaxCheckers);
        ret.validators.putAll(this.validators);
        return ret;
    }

    public void registerKeyword(Keyword keyword) {
        String name = keyword.getName();
        SyntaxChecker checker = keyword.getSyntaxChecker();
        this.syntaxCheckers.remove(name);
        if (checker != null) {
            this.syntaxCheckers.put(name, checker);
        }
        Class<? extends KeywordValidator> validatorClass = keyword.getValidatorClass();
        this.validators.remove(name);
        if (validatorClass != null) {
            this.validators.put(name, validatorClass);
        }
    }

    public void unregisterKeyword(String name) {
        this.syntaxCheckers.remove(name);
        this.validators.remove(name);
    }

    public Map<String, SyntaxChecker> getSyntaxCheckers() {
        return ImmutableMap.copyOf(this.syntaxCheckers);
    }

    public Map<String, Class<? extends KeywordValidator>> getValidators() {
        return ImmutableMap.copyOf(this.validators);
    }
}

