/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.pool;

import com.github.jasync.sql.db.pool.ActorBasedObjectPool;
import com.github.jasync.sql.db.pool.ActorBasedObjectPoolKt;
import com.github.jasync.sql.db.pool.ActorObjectPoolMessage;
import com.github.jasync.sql.db.pool.AsyncObjectPool;
import com.github.jasync.sql.db.pool.Close;
import com.github.jasync.sql.db.pool.GiveBack;
import com.github.jasync.sql.db.pool.ObjectFactory;
import com.github.jasync.sql.db.pool.ObjectPoolActor;
import com.github.jasync.sql.db.pool.PoolAlreadyTerminatedException;
import com.github.jasync.sql.db.pool.PoolConfiguration;
import com.github.jasync.sql.db.pool.PooledObject;
import com.github.jasync.sql.db.pool.Take;
import com.github.jasync.sql.db.pool.TestAvailableItems;
import com.github.jasync.sql.db.pool.TestConnectionScheduler;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.channels.ActorKt;
import kotlinx.coroutines.channels.ActorScope;
import kotlinx.coroutines.channels.ChannelIterator;
import kotlinx.coroutines.channels.SendChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004B\u001d\b\u0016\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB%\b\u0000\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0014\u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030)H\u0016J!\u0010,\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030)2\u0006\u0010-\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010.J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u00028\u00000)H\u0016J\u0006\u00100\u001a\u000201R\u001a\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0002\b\u0003\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000\u00138F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0015R\u0011\u0010$\u001a\u00020%8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u001d\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000)0\u00138F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0015\u00a8\u00062"}, d2={"Lcom/github/jasync/sql/db/pool/ActorBasedObjectPool;", "T", "Lcom/github/jasync/sql/db/pool/PooledObject;", "Lcom/github/jasync/sql/db/pool/AsyncObjectPool;", "Lkotlinx/coroutines/CoroutineScope;", "objectFactory", "Lcom/github/jasync/sql/db/pool/ObjectFactory;", "configuration", "Lcom/github/jasync/sql/db/pool/PoolConfiguration;", "(Lcom/github/jasync/sql/db/pool/ObjectFactory;Lcom/github/jasync/sql/db/pool/PoolConfiguration;)V", "testItemsPeriodically", "", "(Lcom/github/jasync/sql/db/pool/ObjectFactory;Lcom/github/jasync/sql/db/pool/PoolConfiguration;Z)V", "actor", "Lkotlinx/coroutines/channels/SendChannel;", "Lcom/github/jasync/sql/db/pool/ActorObjectPoolMessage;", "actorInstance", "Lcom/github/jasync/sql/db/pool/ObjectPoolActor;", "availableItems", "", "getAvailableItems", "()Ljava/util/List;", "closed", "getClosed", "()Z", "setClosed", "(Z)V", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "job", "testItemsFuture", "Ljava/util/concurrent/ScheduledFuture;", "usedItems", "getUsedItems", "usedItemsSize", "", "getUsedItemsSize", "()I", "waitingForItem", "Ljava/util/concurrent/CompletableFuture;", "getWaitingForItem", "close", "giveBack", "item", "(Lcom/github/jasync/sql/db/pool/PooledObject;)Ljava/util/concurrent/CompletableFuture;", "take", "testAvailableItems", "", "jasync-common"})
public final class ActorBasedObjectPool<T extends PooledObject>
implements AsyncObjectPool<T>,
CoroutineScope {
    private final CoroutineContext job;
    private boolean closed;
    private ScheduledFuture<?> testItemsFuture;
    private final ObjectPoolActor<T> actorInstance;
    private final SendChannel<ActorObjectPoolMessage<T>> actor;

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.job;
    }

    public final boolean getClosed() {
        return this.closed;
    }

    public final void setClosed(boolean bl) {
        this.closed = bl;
    }

    @Override
    @NotNull
    public CompletableFuture<T> take() {
        if (this.closed) {
            throw (Throwable)new PoolAlreadyTerminatedException();
        }
        CompletableFuture future = new CompletableFuture();
        boolean offered = this.actor.offer(new Take(future));
        if (!offered) {
            future.completeExceptionally(new Exception("could not offer to actor"));
        }
        return future;
    }

    @Override
    @NotNull
    public CompletableFuture<AsyncObjectPool<T>> giveBack(@NotNull T item) {
        Intrinsics.checkParameterIsNotNull(item, (String)"item");
        CompletableFuture future = new CompletableFuture();
        boolean offered = this.actor.offer(new GiveBack((PooledObject)item, future, null, null, 12, null));
        if (!offered) {
            future.completeExceptionally(new Exception("could not offer to actor"));
        }
        CompletableFuture $receiver$iv = future;
        CompletionStage completionStage = $receiver$iv.thenApply(new Function<T, U>(this){
            final /* synthetic */ ActorBasedObjectPool this$0;
            {
                this.this$0 = actorBasedObjectPool;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Object apply(Object it) {
                Unit it2 = (Unit)it;
                return this.this$0;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)completionStage, (String)"thenApply { f(it) }");
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<AsyncObjectPool<T>> close() {
        if (this.closed) {
            CompletableFuture<AsyncObjectPool<T>> completableFuture = CompletableFuture.completedFuture(this);
            Intrinsics.checkExpressionValueIsNotNull(completableFuture, (String)"CompletableFuture.completedFuture(this)");
            return completableFuture;
        }
        ActorBasedObjectPoolKt.access$getLogger$p().info((Function0)close.1.INSTANCE);
        this.closed = true;
        CompletableFuture<Unit> future = new CompletableFuture<Unit>();
        boolean offered = this.actor.offer(new Close(future));
        if (!offered) {
            future.completeExceptionally(new Exception("could not offer to actor"));
        }
        ScheduledFuture<?> scheduledFuture2 = this.testItemsFuture;
        if (scheduledFuture2 != null) {
            scheduledFuture2.cancel(true);
        }
        CompletableFuture<Unit> $receiver$iv = future;
        CompletionStage completionStage = $receiver$iv.thenApply(new Function<T, U>(this){
            final /* synthetic */ ActorBasedObjectPool this$0;
            {
                this.this$0 = actorBasedObjectPool;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Object apply(Object it) {
                Unit it2 = (Unit)it;
                JobKt.cancel((CoroutineContext)ActorBasedObjectPool.access$getJob$p(this.this$0));
                return this.this$0;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)completionStage, (String)"thenApply { f(it) }");
        return completionStage;
    }

    public final void testAvailableItems() {
        if (this.closed) {
            ActorBasedObjectPoolKt.access$getLogger$p().trace((Function0)testAvailableItems.1.INSTANCE);
            return;
        }
        ActorBasedObjectPoolKt.access$getLogger$p().trace((Function0)testAvailableItems.2.INSTANCE);
        boolean offered = this.actor.offer(new TestAvailableItems());
        if (!offered) {
            ActorBasedObjectPoolKt.access$getLogger$p().warn((Function0)testAvailableItems.3.INSTANCE);
        }
    }

    @NotNull
    public final List<T> getAvailableItems() {
        return this.actorInstance.getAvailableItemsList();
    }

    @NotNull
    public final List<T> getUsedItems() {
        return this.actorInstance.getUsedItemsList();
    }

    @NotNull
    public final List<CompletableFuture<T>> getWaitingForItem() {
        return this.actorInstance.getWaitingForItemList();
    }

    public final int getUsedItemsSize() {
        return this.actorInstance.getUsedItemsSize();
    }

    public ActorBasedObjectPool(@NotNull ObjectFactory<T> objectFactory, final @NotNull PoolConfiguration configuration, boolean testItemsPeriodically) {
        Intrinsics.checkParameterIsNotNull(objectFactory, (String)"objectFactory");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        this.job = SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)Dispatchers.getDefault());
        if (testItemsPeriodically) {
            ActorBasedObjectPoolKt.access$getLogger$p().info((Function0)new Function0<String>(){

                @NotNull
                public final String invoke() {
                    return "registering pool for periodic connection tests " + this + " - " + configuration;
                }
            });
            this.testItemsFuture = TestConnectionScheduler.INSTANCE.scheduleAtFixedRate(configuration.getValidationInterval(), (Function0<Unit>)((Function0)new Function0<Unit>(){

                public final void invoke() {
                    try {
                        this.testAvailableItems();
                    }
                    catch (Throwable t) {
                        ActorBasedObjectPoolKt.access$getLogger$p().debug(t, (Function0)1.INSTANCE);
                    }
                }
            }));
        }
        this.actorInstance = new ObjectPoolActor<T>(objectFactory, configuration, (Function0)new Function0<SendChannel<? super ActorObjectPoolMessage<T>>>(this){
            final /* synthetic */ ActorBasedObjectPool this$0;

            @NotNull
            public final SendChannel<ActorObjectPoolMessage<T>> invoke() {
                return ActorBasedObjectPool.access$getActor$p(this.this$0);
            }
            {
                this.this$0 = actorBasedObjectPool;
                super(0);
            }
        });
        this.actor = ActorKt.actor((CoroutineScope)this, (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (int)Integer.MAX_VALUE, (CoroutineStart)CoroutineStart.DEFAULT, null, (Function2)new Function2<ActorScope<ActorObjectPoolMessage<T>>, Continuation<? super Unit>, Object>(this, null){
            private ActorScope p$;
            Object L$0;
            int label;
            final /* synthetic */ ActorBasedObjectPool this$0;

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object result) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        v0 = result;
                        if (v0 instanceof Result.Failure) {
                            throw ((Result.Failure)v0).exception;
                        }
                        var2_3 = this.p$;
                        var4_4 = var2_3.getChannel().iterator();
lbl9:
                        // 2 sources

                        while (true) {
                            this.L$0 = var4_4;
                            this.label = 1;
                            v1 = var4_4.hasNext((Continuation)this);
                            if (v1 == var6_2) {
                                return var6_2;
                            }
                            ** GOTO lbl22
                            break;
                        }
                    }
                    case 1: {
                        var4_4 = (ChannelIterator)this.L$0;
                        v2 = result;
                        if (v2 instanceof Result.Failure) {
                            throw ((Result.Failure)v2).exception;
                        }
                        v1 = result;
lbl22:
                        // 2 sources

                        if (!((Boolean)v1).booleanValue()) break;
                        this.L$0 = var4_4;
                        this.label = 2;
                        v3 = var4_4.next((Continuation)this);
                        if (v3 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl35
                    }
                    case 2: {
                        var4_4 = (ChannelIterator)this.L$0;
                        v4 = result;
                        if (v4 instanceof Result.Failure) {
                            throw ((Result.Failure)v4).exception;
                        }
                        v3 = result;
lbl35:
                        // 2 sources

                        message = (ActorObjectPoolMessage)v3;
                        try {
                            ActorBasedObjectPool.access$getActorInstance$p(this.this$0).onReceive(message);
                        }
                        catch (Throwable t) {
                            ActorBasedObjectPoolKt.access$getLogger$p().warn(t, (Function0)actor.1.INSTANCE);
                        }
                        ** continue;
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = actorBasedObjectPool;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                Function2<ActorScope<ActorObjectPoolMessage<T>>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                ActorScope actorScope = function2.p$ = (ActorScope)value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    public ActorBasedObjectPool(@NotNull ObjectFactory<T> objectFactory, @NotNull PoolConfiguration configuration) {
        Intrinsics.checkParameterIsNotNull(objectFactory, (String)"objectFactory");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        this(objectFactory, configuration, true);
    }

    @Override
    @NotNull
    public <A> CompletableFuture<A> use(@NotNull Executor executor2, @NotNull Function1<? super T, ? extends CompletableFuture<A>> function) {
        Intrinsics.checkParameterIsNotNull((Object)executor2, (String)"executor");
        Intrinsics.checkParameterIsNotNull(function, (String)"function");
        return AsyncObjectPool.DefaultImpls.use(this, executor2, function);
    }

    @NotNull
    public static final /* synthetic */ CoroutineContext access$getJob$p(ActorBasedObjectPool $this) {
        return $this.job;
    }

    @NotNull
    public static final /* synthetic */ SendChannel access$getActor$p(ActorBasedObjectPool $this) {
        return $this.actor;
    }

    @NotNull
    public static final /* synthetic */ ObjectPoolActor access$getActorInstance$p(ActorBasedObjectPool $this) {
        return $this.actorInstance;
    }
}

