/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.column;

import com.github.jasync.sql.db.column.ColumnEncoderDecoder;
import com.github.jasync.sql.db.exceptions.DateEncoderNotAvailableException;
import com.github.jasync.sql.db.general.ColumnData;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.sql.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0004H\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/github/jasync/sql/db/column/DateEncoderDecoder;", "Lcom/github/jasync/sql/db/column/ColumnEncoderDecoder;", "()V", "ZeroedDate", "", "formatter", "Lorg/joda/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "decode", "Lorg/joda/time/LocalDate;", "value", "encode", "", "jasync-common"})
public final class DateEncoderDecoder
implements ColumnEncoderDecoder {
    private static final String ZeroedDate = "0000-00-00";
    private static final DateTimeFormatter formatter;
    public static final DateEncoderDecoder INSTANCE;

    @Nullable
    public LocalDate decode(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return Intrinsics.areEqual((Object)ZeroedDate, (Object)value) ? null : formatter.parseLocalDate(value);
    }

    @Override
    @NotNull
    public String encode(@NotNull Object value) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Object object = value;
        if (object instanceof Date) {
            String string2 = formatter.print((ReadablePartial)new LocalDate(value));
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"this.formatter.print(LocalDate(value))");
        } else if (object instanceof ReadablePartial) {
            String string3 = formatter.print((ReadablePartial)value);
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"this.formatter.print(value)");
        } else {
            throw (Throwable)new DateEncoderNotAvailableException(value);
        }
        return string;
    }

    private DateEncoderDecoder() {
    }

    static {
        DateEncoderDecoder dateEncoderDecoder;
        INSTANCE = dateEncoderDecoder = new DateEncoderDecoder();
        ZeroedDate = ZeroedDate;
        formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    }

    @Override
    @Nullable
    public Object decode(@NotNull ColumnData kind, @NotNull ByteBuf value, @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        return ColumnEncoderDecoder.DefaultImpls.decode(this, kind, value, charset);
    }

    @Override
    public boolean supportsStringDecoding() {
        return ColumnEncoderDecoder.DefaultImpls.supportsStringDecoding(this);
    }
}

