/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasminb.jsonapi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class SerializationSettings {
    private List<String> relationshipIncludes;
    private List<String> relationshipExludes;
    private Boolean serializeMeta;
    private Boolean serializeLinks;
    private Boolean serializeId;

    private SerializationSettings() {
    }

    public boolean isRelationshipIncluded(String relationshipName) {
        return this.relationshipIncludes.contains(relationshipName);
    }

    public boolean isRelationshipExcluded(String relationshipName) {
        return this.relationshipExludes.contains(relationshipName);
    }

    public boolean hasIncludedRelationships() {
        HashSet<String> includedRelationships = new HashSet<String>(this.relationshipIncludes);
        includedRelationships.removeAll(this.relationshipExludes);
        return !includedRelationships.isEmpty();
    }

    public Boolean serializeMeta() {
        return this.serializeMeta;
    }

    public Boolean serializeLinks() {
        return this.serializeLinks;
    }

    public Boolean serializeId() {
        return this.serializeId;
    }

    public static class Builder {
        private List<String> relationshipIncludes = new ArrayList<String>();
        private List<String> relationshipExludes = new ArrayList<String>();
        private Boolean serializeMeta;
        private Boolean serializeLinks;
        private Boolean serializeId;

        public Builder includeRelationship(String relationshipName) {
            this.relationshipIncludes.add(relationshipName);
            return this;
        }

        public Builder excludedRelationships(String relationshipName) {
            this.relationshipExludes.add(relationshipName);
            return this;
        }

        public Builder serializeMeta(Boolean flag) {
            this.serializeMeta = flag;
            return this;
        }

        public Builder serializeLinks(Boolean flag) {
            this.serializeLinks = flag;
            return this;
        }

        public Builder serializeId(Boolean flag) {
            this.serializeId = flag;
            return this;
        }

        public SerializationSettings build() {
            SerializationSettings result = new SerializationSettings();
            result.relationshipIncludes = new ArrayList<String>(this.relationshipIncludes);
            result.relationshipExludes = new ArrayList<String>(this.relationshipExludes);
            result.serializeLinks = this.serializeLinks;
            result.serializeMeta = this.serializeMeta;
            result.serializeId = this.serializeId;
            return result;
        }
    }
}

