/*
 * Decompiled with CFR 0.152.
 */
package com.jaouan.compoundlayout;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.LinearGradient;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewAnimationUtils;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.widget.FrameLayout;
import com.jaouan.compoundlayout.R;
import com.jaouan.compoundlayout.RadioLayout;

@TargetApi(value=21)
public class GradientRadioLayout
extends RadioLayout {
    private int mColorA;
    private int mColorB;
    private double mDegreesAngle;
    private FrameLayout mForegroundLayout;
    private int mSideHypot;

    public GradientRadioLayout(Context context) {
        super(context);
        this.initialize(context, null, 0, 0);
    }

    public GradientRadioLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context, attrs, 0, 0);
    }

    public GradientRadioLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context, attrs, defStyleAttr, 0);
    }

    public GradientRadioLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initialize(context, attrs, defStyleAttr, defStyleRes);
    }

    private void initialize(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        if (Build.VERSION.SDK_INT < 21) {
            Log.e((String)"GradientRadioLayout", (String)"GradientRadioLayout is only Android 21+ compatible. The view will crash !");
        }
        TypedArray styleAttributes = context.obtainStyledAttributes(attrs, R.styleable.GradientRadioLayout, defStyleAttr, defStyleRes);
        this.mColorA = styleAttributes.getColor(R.styleable.GradientRadioLayout_colorA, this.getResources().getColor(R.color.color_a_default));
        this.mColorB = styleAttributes.getColor(R.styleable.GradientRadioLayout_colorB, this.getResources().getColor(R.color.color_b_default));
        this.mDegreesAngle = styleAttributes.getInt(R.styleable.GradientRadioLayout_angle, 0);
        styleAttributes.recycle();
    }

    protected void onSizeChanged(int width, int height, int oldWidth, int oldHeight) {
        super.onSizeChanged(width, height, oldWidth, oldHeight);
        this.updateGradientParameters();
    }

    @Override
    public void setChecked(final boolean checked) {
        boolean lastCheckedState = this.isChecked();
        super.setChecked(checked);
        if (this.mForegroundLayout != null && lastCheckedState != this.isChecked()) {
            Animator circularReveal;
            AlphaAnimation alphaAnimation;
            if (checked) {
                alphaAnimation = new AlphaAnimation(0.0f, 1.0f);
                circularReveal = ViewAnimationUtils.createCircularReveal((View)this.mForegroundLayout, (int)((int)((float)this.getWidth() * -0.2f)), (int)(this.getHeight() / 2), (float)0.0f, (float)this.mSideHypot);
            } else {
                alphaAnimation = new AlphaAnimation(1.0f, 0.0f);
                alphaAnimation.setStartOffset(100L);
                circularReveal = ViewAnimationUtils.createCircularReveal((View)this.mForegroundLayout, (int)((int)((float)this.getWidth() * 1.2f)), (int)(this.getHeight() / 2), (float)this.mSideHypot, (float)0.0f);
            }
            alphaAnimation.setDuration(200L);
            alphaAnimation.setInterpolator((Interpolator)new AccelerateDecelerateInterpolator());
            circularReveal.setDuration(300L);
            circularReveal.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
            circularReveal.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animation) {
                    GradientRadioLayout.this.mForegroundLayout.setVisibility(0);
                }

                public void onAnimationEnd(Animator animation) {
                    GradientRadioLayout.this.mForegroundLayout.setVisibility(checked ? 0 : 4);
                }
            });
            circularReveal.start();
            this.mForegroundLayout.startAnimation((Animation)alphaAnimation);
        }
    }

    public int getColorA() {
        return this.mColorA;
    }

    public void setColorA(int colorA) {
        this.mColorA = colorA;
        this.updateGradientParameters();
    }

    public int getColorB() {
        return this.mColorB;
    }

    public void setColorB(int colorB) {
        this.mColorB = colorB;
        this.updateGradientParameters();
    }

    public double getAngle() {
        return this.mDegreesAngle;
    }

    public void setAngle(double degreesAngle) {
        this.mDegreesAngle = degreesAngle;
        this.updateGradientParameters();
    }

    private void updateGradientParameters() {
        this.mSideHypot = (int)Math.hypot(this.getWidth(), this.getHeight());
        ShapeDrawable mDrawable = new ShapeDrawable((Shape)new RectShape());
        double radiansAngle = Math.toRadians(this.mDegreesAngle);
        mDrawable.getPaint().setShader((Shader)new LinearGradient(0.0f, 0.0f, (float)((int)((double)this.mSideHypot * Math.cos(radiansAngle))), (float)((int)((double)this.mSideHypot * Math.sin(radiansAngle))), this.mColorA, this.mColorB, Shader.TileMode.REPEAT));
        if (this.mForegroundLayout == null) {
            this.mForegroundLayout = new FrameLayout(this.getContext());
            this.mForegroundLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            this.addView((View)this.mForegroundLayout);
        }
        this.mForegroundLayout.setVisibility(this.isChecked() ? 0 : 4);
        this.mForegroundLayout.setForeground((Drawable)mDrawable);
    }
}

