/*
 * Decompiled with CFR 0.152.
 */
package com.ixidev.gdpr;

import android.content.Context;
import android.support.annotation.RequiresPermission;
import android.util.Log;
import com.google.ads.consent.ConsentForm;
import com.google.ads.consent.ConsentFormListener;
import com.google.ads.consent.ConsentInfoUpdateListener;
import com.google.ads.consent.ConsentInformation;
import com.google.ads.consent.ConsentStatus;
import com.google.ads.consent.DebugGeography;
import java.net.URL;

public class GDPRChecker {
    private static final String TAG = "GDPRChecker";
    private ConsentInformation consentInformation;
    private Context context;
    private String privacyUrl;
    private ConsentForm form;
    private String[] publisherIds;
    private static GDPRChecker instance;
    private static Request request;
    private boolean withAdFreeOption = false;

    protected GDPRChecker(Context context) {
        this.context = context;
        this.consentInformation = ConsentInformation.getInstance((Context)context);
    }

    public GDPRChecker() {
    }

    public GDPRChecker withContext(Context context) {
        instance = new GDPRChecker(context);
        return instance;
    }

    public GDPRChecker withPrivacyUrl(String privacyUrl) {
        this.privacyUrl = privacyUrl;
        if (instance == null) {
            throw new NullPointerException("Please call withContext first");
        }
        return instance;
    }

    @RequiresPermission(value="android.permission.INTERNET")
    private void initGDPR() {
        if (this.publisherIds == null) {
            throw new NullPointerException("publisherIds is null, please call withPublisherIds first");
        }
        this.consentInformation.requestConsentInfoUpdate(this.publisherIds, new ConsentInfoUpdateListener(){

            public void onConsentInfoUpdated(ConsentStatus consentStatus) {
                switch (consentStatus) {
                    case PERSONALIZED: {
                        request = Request.PERSONALIZED;
                        Log.i((String)GDPRChecker.TAG, (String)"onConsentInfoUpdated: Showing Personalized ads");
                        break;
                    }
                    case NON_PERSONALIZED: {
                        request = Request.NON_PERSONALIZED;
                        Log.i((String)GDPRChecker.TAG, (String)"onConsentInfoUpdated: Showing Non-Personalized ads");
                        break;
                    }
                    case UNKNOWN: {
                        if (GDPRChecker.this.consentInformation.isRequestLocationInEeaOrUnknown()) {
                            GDPRChecker.this.setupForm();
                            break;
                        }
                        request = Request.NON_PERSONALIZED;
                        Log.i((String)GDPRChecker.TAG, (String)("onConsentInfoUpdated:  case UNKNOWN :: GDPRChecker Request :: " + request.name()));
                        break;
                    }
                    default: {
                        request = Request.PERSONALIZED;
                    }
                }
            }

            public void onFailedToUpdateConsentInfo(String errorDescription) {
                Log.e((String)GDPRChecker.TAG, (String)("onFailedToUpdateConsentInfo: " + errorDescription));
            }
        });
    }

    private void setupForm() {
        if (this.privacyUrl == "") {
            throw new NullPointerException("PrivacyUrl is null, Please call withPrivacyUrl first");
        }
        URL Url = null;
        try {
            Url = new URL(this.privacyUrl);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"initGDPR: ", (Throwable)e);
        }
        ConsentForm.Builder builder = new ConsentForm.Builder(this.context, Url).withListener(new ConsentFormListener(){

            public void onConsentFormLoaded() {
                GDPRChecker.this.showForm();
            }

            public void onConsentFormOpened() {
                Log.i((String)GDPRChecker.TAG, (String)"onConsentFormOpened: ");
            }

            public void onConsentFormClosed(ConsentStatus consentStatus, Boolean userPrefersAdFree) {
                GDPRChecker.this.consentInformation.setConsentStatus(consentStatus);
                if (userPrefersAdFree.booleanValue()) {
                    Log.i((String)GDPRChecker.TAG, (String)"Requesting Consent: User prefers AdFree");
                } else {
                    Log.i((String)GDPRChecker.TAG, (String)"Requesting Consent: Requesting consent again");
                    switch (consentStatus) {
                        case PERSONALIZED: {
                            request = Request.PERSONALIZED;
                            break;
                        }
                        case NON_PERSONALIZED: {
                            request = Request.NON_PERSONALIZED;
                            break;
                        }
                        case UNKNOWN: {
                            request = Request.NON_PERSONALIZED;
                        }
                    }
                }
            }

            public void onConsentFormError(String errorDescription) {
                Log.e((String)GDPRChecker.TAG, (String)("onConsentFormError: " + errorDescription));
            }
        }).withPersonalizedAdsOption().withNonPersonalizedAdsOption();
        if (this.withAdFreeOption) {
            builder.withAdFreeOption();
        }
        this.form = builder.build();
        this.form.load();
    }

    private void showForm() {
        this.form.show();
    }

    public void check() {
        this.initGDPR();
    }

    public GDPRChecker withPublisherIds(String ... publisherIds) {
        this.publisherIds = publisherIds;
        if (instance == null) {
            throw new NullPointerException("Please call withContext first");
        }
        return instance;
    }

    public GDPRChecker withTestMode(String testDevice) {
        this.consentInformation.setDebugGeography(DebugGeography.DEBUG_GEOGRAPHY_EEA);
        this.consentInformation.addTestDevice(testDevice);
        if (instance == null) {
            throw new NullPointerException("Please call withContext first");
        }
        return instance;
    }

    public GDPRChecker withTestMode() {
        this.consentInformation.setDebugGeography(DebugGeography.DEBUG_GEOGRAPHY_EEA);
        if (instance == null) {
            throw new NullPointerException("Please call withContext first");
        }
        return instance;
    }

    public static Request getRequest() {
        return request;
    }

    public void setWithAdFreeOption(boolean withAdFreeOption) {
        this.withAdFreeOption = withAdFreeOption;
    }

    static {
        request = Request.PERSONALIZED;
    }

    public static enum Request {
        PERSONALIZED,
        NON_PERSONALIZED;

    }
}

