/*
 * Decompiled with CFR 0.152.
 */
package net.io_0.caja.async;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.io_0.caja.LoggingUtils;
import net.io_0.caja.async.Cache;
import net.io_0.caja.async.CacheDecorator;
import net.io_0.caja.configuration.CacheConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingStatisticsDecorator<K, V>
extends CacheDecorator<K, V> {
    private static final Logger log = LoggerFactory.getLogger(LoggingStatisticsDecorator.class);
    private final String name;
    private final CacheConfig.LogLevel logLevel;

    public LoggingStatisticsDecorator(String name, CacheConfig.LogLevel logLevel, Cache<K, V> cache) {
        super(cache);
        this.name = name;
        this.logLevel = logLevel;
    }

    @Override
    public CompletableFuture<V> get(K key) {
        return this.cache.get(key).whenComplete((value, error) -> {
            if (Objects.isNull(error)) {
                this.log("{}: {} value for '{}'", this.name, Objects.nonNull(value) ? "got" : "missed", key);
            }
        });
    }

    @Override
    public CompletableFuture<Void> put(K key, V value) {
        return this.cache.put(key, value).whenComplete((ignored, error) -> {
            if (Objects.isNull(error)) {
                this.log("{}: put value for '{}'", this.name, key);
            }
        });
    }

    @Override
    public CompletableFuture<Boolean> containsKey(K key) {
        return this.cache.containsKey(key).whenComplete((value, error) -> {
            if (Objects.isNull(error) && Objects.nonNull(value)) {
                this.log("{}: {} key '{}'", this.name, value != false ? "contained" : "missed", key);
            }
        });
    }

    @Override
    public CompletableFuture<List<K>> keys() {
        return this.cache.keys().whenComplete((keys, error) -> {
            if (Objects.isNull(error)) {
                this.log("{}: fetched {} active keys", this.name, keys.size());
            }
        });
    }

    @Override
    public CompletableFuture<Void> remove(K key) {
        return this.cache.remove(key).whenComplete((ignored, error) -> {
            if (Objects.isNull(error)) {
                this.log("{}: removed value for '{}'", this.name, key);
            }
        });
    }

    @Override
    public CompletableFuture<Void> clear() {
        return this.cache.clear().whenComplete((ignored, error) -> {
            if (Objects.isNull(error)) {
                this.log("{}: cleared", this.name);
            }
        });
    }

    private void log(String format, Object ... arguments) {
        LoggingUtils.logThrough(log, this.logLevel, format, arguments);
    }
}

