/*
 * Decompiled with CFR 0.152.
 */
package net.io_0.caja;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncUtils {
    private static final Logger log = LoggerFactory.getLogger(AsyncUtils.class);
    public static final Duration MAX_NANO_DURATION = Duration.ofNanos(Long.MAX_VALUE);

    public static <T> T await(CompletableFuture<T> future) {
        return AsyncUtils.await(future, null);
    }

    public static <T> T await(CompletableFuture<T> future, Duration timeout) {
        try {
            if (Objects.isNull(timeout)) {
                return future.get();
            }
            return timeout.compareTo(MAX_NANO_DURATION) > 0 ? future.get(timeout.getSeconds(), TimeUnit.SECONDS) : future.get(timeout.toNanos(), TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException | TimeoutException e) {
            log.error("failed to await", (Throwable)e);
            return null;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private AsyncUtils() {
    }
}

