/*
 * Decompiled with CFR 0.152.
 */
package com.instacart.library.truetime;

import android.os.SystemClock;
import android.util.Log;
import com.instacart.library.truetime.SntpClient;
import java.io.IOException;
import java.util.Date;

public class TrueTime {
    private static final String TAG = TrueTime.class.getSimpleName();
    private static final TrueTime INSTANCE = new TrueTime();
    private String _ntpHost = "1.us.pool.ntp.org";
    private SntpClient _sntpClient;
    private boolean _sntpInitialized = false;
    private int _udpSocketTimeoutInMillis = 30000;

    public static TrueTime build() {
        return INSTANCE;
    }

    public static Date now() {
        if (!TrueTime.isInitialized()) {
            throw new IllegalStateException("You need to call init() on TrueTime at least once.");
        }
        long now = TrueTime.INSTANCE._sntpClient.getCachedSntpTime() + SystemClock.elapsedRealtime() - TrueTime.INSTANCE._sntpClient.getCachedDeviceUptime();
        return new Date(now);
    }

    public static boolean isInitialized() {
        return TrueTime.INSTANCE._sntpInitialized;
    }

    public synchronized TrueTime withConnectionTimeout(int timeoutInMillis) {
        this._udpSocketTimeoutInMillis = timeoutInMillis;
        return INSTANCE;
    }

    public synchronized TrueTime withNtpHost(String ntpHost) {
        this._ntpHost = ntpHost;
        return INSTANCE;
    }

    public void initialize() {
        SntpClient sntpClient = new SntpClient();
        try {
            sntpClient.requestTime(TrueTime.INSTANCE._ntpHost, TrueTime.INSTANCE._udpSocketTimeoutInMillis);
            Log.i((String)TAG, (String)"---- SNTP request successful");
            TrueTime.setSntpClient(sntpClient);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"TrueTime initialization failed", (Throwable)new Throwable(e));
            this._sntpInitialized = false;
        }
    }

    protected static synchronized void setSntpClient(SntpClient sntpClient) {
        TrueTime.INSTANCE._sntpClient = sntpClient;
        TrueTime.INSTANCE._sntpInitialized = true;
    }

    protected static int getUdpSocketTimeout() {
        return TrueTime.INSTANCE._udpSocketTimeoutInMillis;
    }
}

