/*
 * Decompiled with CFR 0.152.
 */
package com.instacart.library.truetime;

import android.os.SystemClock;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class SntpClient {
    private static final int NTP_PORT = 123;
    private static final int NTP_MODE = 3;
    private static final int NTP_VERSION = 3;
    private static final int NTP_PACKET_SIZE = 48;
    private static final int INDEX_VERSION = 0;
    private static final int INDEX_ROOT_DELAY = 4;
    private static final int INDEX_ROOT_DISPERSION = 8;
    private static final int INDEX_ORIGINATE_TIME = 24;
    private static final int INDEX_RECEIVE_TIME = 32;
    private static final int INDEX_TRANSMIT_TIME = 40;
    private static final long OFFSET_1900_TO_1970 = 2208988800L;
    private long _cachedDeviceUptime;
    private long _cachedSntpTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestTime(String ntpHost, int timeoutInMillis) throws IOException {
        try (DatagramSocket socket = null;){
            byte[] buffer = new byte[48];
            InetAddress address = InetAddress.getByName(ntpHost);
            DatagramPacket request = new DatagramPacket(buffer, buffer.length, address, 123);
            this._writeVersion(buffer);
            long requestTime = System.currentTimeMillis();
            long requestTicks = SystemClock.elapsedRealtime();
            this._writeTimeStamp(buffer, 40, requestTime);
            socket = new DatagramSocket();
            socket.setSoTimeout(timeoutInMillis);
            socket.send(request);
            DatagramPacket response = new DatagramPacket(buffer, buffer.length);
            socket.receive(response);
            long responseTicks = SystemClock.elapsedRealtime();
            long originateTime = this._readTimeStamp(buffer, 24);
            long receiveTime = this._readTimeStamp(buffer, 32);
            long transmitTime = this._readTimeStamp(buffer, 40);
            long responseTime = requestTime + (responseTicks - requestTicks);
            long originTimeDiff = Math.abs(requestTime - originateTime);
            if (originTimeDiff > 1L) {
                throw new RuntimeException("Invalid response from NTP server. Originating times differed by " + originTimeDiff);
            }
            long rootDelay = this._read(buffer, 4);
            if (rootDelay > 100L) {
                throw new RuntimeException("Invalid response from NTP server. Root delay violation " + rootDelay);
            }
            long rootDispersion = this._read(buffer, 8);
            if (rootDispersion > 100L) {
                throw new RuntimeException("Invalid response from NTP server. Root dispersion violation " + rootDispersion);
            }
            long clockOffset = (receiveTime - originateTime + (transmitTime - responseTime)) / 2L;
            this._cachedSntpTime = responseTime + clockOffset;
            this._cachedDeviceUptime = responseTicks;
        }
    }

    long getCachedSntpTime() {
        return this._cachedSntpTime;
    }

    long getCachedDeviceUptime() {
        return this._cachedDeviceUptime;
    }

    private void _writeVersion(byte[] buffer) {
        buffer[0] = 27;
    }

    private void _writeTimeStamp(byte[] buffer, int offset, long time) {
        long seconds = time / 1000L;
        long milliseconds = time - seconds * 1000L;
        buffer[offset++] = (byte)((seconds += 2208988800L) >> 24);
        buffer[offset++] = (byte)(seconds >> 16);
        buffer[offset++] = (byte)(seconds >> 8);
        buffer[offset++] = (byte)(seconds >> 0);
        long fraction = milliseconds * 0x100000000L / 1000L;
        buffer[offset++] = (byte)(fraction >> 24);
        buffer[offset++] = (byte)(fraction >> 16);
        buffer[offset++] = (byte)(fraction >> 8);
        buffer[offset++] = (byte)(Math.random() * 255.0);
    }

    private long _readTimeStamp(byte[] buffer, int offset) {
        long seconds = this._read(buffer, offset);
        long fraction = this._read(buffer, offset + 4);
        return (seconds - 2208988800L) * 1000L + fraction * 1000L / 0x100000000L;
    }

    private long _read(byte[] buffer, int offset) {
        byte b0 = buffer[offset];
        byte b1 = buffer[offset + 1];
        byte b2 = buffer[offset + 2];
        byte b3 = buffer[offset + 3];
        return ((long)this.ui(b0) << 24) + ((long)this.ui(b1) << 16) + ((long)this.ui(b2) << 8) + (long)this.ui(b3);
    }

    private int ui(byte b) {
        return (b & 0x80) == 128 ? (b & 0x7F) + 128 : b;
    }
}

