/*
 * Decompiled with CFR 0.152.
 */
package com.ihsanbal.logging;

import com.ihsanbal.logging.Level;
import com.ihsanbal.logging.Logger;
import com.ihsanbal.logging.Printer;
import com.ihsanbal.logging.TextUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class LoggingInterceptor
implements Interceptor {
    private boolean isDebug;
    private Builder builder;

    private LoggingInterceptor(Builder builder) {
        this.builder = builder;
        this.isDebug = builder.isDebug;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        HashMap<String, String> queryMap;
        Request request = chain.request();
        HashMap<String, String> headerMap = this.builder.getHeaders();
        if (headerMap.size() > 0) {
            Headers headers = request.headers();
            Set names = headers.names();
            Iterator<Object> iterator = names.iterator();
            Request.Builder requestBuilder = request.newBuilder();
            for (String key : headerMap.keySet()) {
                String value = headerMap.get(key);
                requestBuilder.addHeader(key, value);
            }
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                requestBuilder.addHeader(name, headers.get(name));
            }
            request = requestBuilder.build();
        }
        if ((queryMap = this.builder.getHttpUrl()).size() > 0) {
            HttpUrl.Builder httpUrlBuilder = request.url().newBuilder(request.url().toString());
            for (String key : queryMap.keySet()) {
                String value = queryMap.get(key);
                httpUrlBuilder.addQueryParameter(key, value);
            }
            request = request.newBuilder().url(httpUrlBuilder.build()).build();
        }
        if (!this.isDebug || this.builder.getLevel() == Level.NONE) {
            return chain.proceed(request);
        }
        RequestBody requestBody = request.body();
        String rSubtype = null;
        if (requestBody != null && requestBody.contentType() != null) {
            rSubtype = requestBody.contentType().subtype();
        }
        if (this.isNotFileRequest(rSubtype)) {
            Printer.printJsonRequest(this.builder, request);
        } else {
            Printer.printFileRequest(this.builder, request);
        }
        long st = System.nanoTime();
        Response response = chain.proceed(request);
        long chainMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - st);
        List segmentList = request.url().encodedPathSegments();
        String header = response.headers().toString();
        int code = response.code();
        boolean isSuccessful = response.isSuccessful();
        String message = response.message();
        ResponseBody responseBody = response.body();
        MediaType contentType = responseBody.contentType();
        String subtype = null;
        if (contentType != null) {
            subtype = contentType.subtype();
        }
        if (!this.isNotFileRequest(subtype)) {
            Printer.printFileResponse(this.builder, chainMs, isSuccessful, code, header, segmentList, message);
            return response;
        }
        String bodyString = Printer.getJsonString(responseBody.string());
        String url = response.request().url().toString();
        Printer.printJsonResponse(this.builder, chainMs, isSuccessful, code, header, bodyString, segmentList, message, url);
        ResponseBody body = ResponseBody.create((MediaType)contentType, (String)bodyString);
        return response.newBuilder().body(body).build();
    }

    private boolean isNotFileRequest(String subtype) {
        return subtype != null && (subtype.contains("json") || subtype.contains("xml") || subtype.contains("plain") || subtype.contains("html"));
    }

    public static class Builder {
        private static String TAG = "LoggingI";
        private boolean isDebug;
        private int type = 4;
        private String requestTag;
        private String responseTag;
        private Level level = Level.BASIC;
        private Logger logger;
        private final HashMap<String, String> headers = new HashMap();
        private final HashMap<String, String> queries = new HashMap();

        int getType() {
            return this.type;
        }

        Level getLevel() {
            return this.level;
        }

        HashMap<String, String> getHeaders() {
            return this.headers;
        }

        HashMap<String, String> getHttpUrl() {
            return this.queries;
        }

        String getTag(boolean isRequest) {
            if (isRequest) {
                return TextUtils.isEmpty(this.requestTag) ? TAG : this.requestTag;
            }
            return TextUtils.isEmpty(this.responseTag) ? TAG : this.responseTag;
        }

        Logger getLogger() {
            return this.logger;
        }

        public Builder addHeader(String name, String value) {
            this.headers.put(name, value);
            return this;
        }

        public Builder addQueryParam(String name, String value) {
            this.queries.put(name, value);
            return this;
        }

        public Builder setLevel(Level level) {
            this.level = level;
            return this;
        }

        public Builder tag(String tag) {
            TAG = tag;
            return this;
        }

        public Builder request(String tag) {
            this.requestTag = tag;
            return this;
        }

        public Builder response(String tag) {
            this.responseTag = tag;
            return this;
        }

        public Builder loggable(boolean isDebug) {
            this.isDebug = isDebug;
            return this;
        }

        public Builder log(int type) {
            this.type = type;
            return this;
        }

        public Builder logger(Logger logger) {
            this.logger = logger;
            return this;
        }

        public LoggingInterceptor build() {
            return new LoggingInterceptor(this);
        }
    }
}

