/*
 * Decompiled with CFR 0.152.
 */
package com.ihsanbal.logging;

import android.text.TextUtils;
import com.ihsanbal.logging.I;
import com.ihsanbal.logging.Level;
import com.ihsanbal.logging.LoggingInterceptor;
import java.io.IOException;
import okhttp3.Request;
import okio.Buffer;
import okio.BufferedSink;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class Logger {
    private static final int JSON_INDENT = 4;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String DOUBLE_SEPARATOR = LINE_SEPARATOR + LINE_SEPARATOR;

    Logger() {
        throw new UnsupportedOperationException("you can't instantiate me");
    }

    private static boolean isEmpty(String line) {
        return TextUtils.isEmpty((CharSequence)line) || line.equals("\n") || line.equals("\t") || TextUtils.isEmpty((CharSequence)line.trim());
    }

    static void printJsonRequest(LoggingInterceptor.Builder builder, Request request) {
        String requestBody = LINE_SEPARATOR + "Body:" + LINE_SEPARATOR + Logger.bodyToString(request);
        String tag = builder.getTag(true);
        I.Log(builder.getType(), tag, "\u2554\u2550\u2550\u2550\u2550\u2550\u2550 Request \u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        Logger.logLines(builder.getType(), tag, Logger.getRequest(request, builder.getLevel()));
        if (builder.getLevel() == Level.BASIC || builder.getLevel() == Level.BODY) {
            Logger.logLines(builder.getType(), tag, requestBody.split(LINE_SEPARATOR));
        }
        I.Log(builder.getType(), tag, "\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
    }

    static void printJsonResponse(LoggingInterceptor.Builder builder, long chainMs, boolean isSuccessful, int code, String headers, String bodyString) {
        String responseBody = LINE_SEPARATOR + "Body:" + LINE_SEPARATOR + Logger.getJsonString(bodyString);
        String tag = builder.getTag(false);
        I.Log(builder.getType(), tag, "\u2554\u2550\u2550\u2550\u2550\u2550\u2550 Response \u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        Logger.logLines(builder.getType(), tag, Logger.getResponse(headers, chainMs, code, isSuccessful, builder.getLevel()));
        if (builder.getLevel() == Level.BASIC || builder.getLevel() == Level.BODY) {
            Logger.logLines(builder.getType(), tag, responseBody.split(LINE_SEPARATOR));
        }
        I.Log(builder.getType(), tag, "\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
    }

    private static String[] getRequest(Request request, Level level) {
        String header = request.headers().toString();
        boolean loggableHeader = level == Level.HEADERS || level == Level.BASIC;
        String message = "URL: " + request.url() + DOUBLE_SEPARATOR + "Method: @" + request.method() + DOUBLE_SEPARATOR + (Logger.isEmpty(header) ? "" : (loggableHeader ? "Headers:" + LINE_SEPARATOR + Logger.dotHeaders(header) : ""));
        return message.split(LINE_SEPARATOR);
    }

    private static String[] getResponse(String header, long tookMs, int code, boolean isSuccessful, Level level) {
        boolean loggableHeader = level == Level.HEADERS || level == Level.BASIC;
        String message = "Result is Successful: " + isSuccessful + DOUBLE_SEPARATOR + "Status Code: " + code + DOUBLE_SEPARATOR + (Logger.isEmpty(header) ? "" : (loggableHeader ? "Headers:" + LINE_SEPARATOR + Logger.dotHeaders(header) : "")) + LINE_SEPARATOR + "Received in: " + tookMs + "ms";
        return message.split(LINE_SEPARATOR);
    }

    private static String dotHeaders(String header) {
        String[] headers = header.split(LINE_SEPARATOR);
        StringBuilder builder = new StringBuilder();
        for (String item : headers) {
            builder.append("- ").append(item).append("\n");
        }
        return builder.toString();
    }

    private static void logLines(int type, String tag, String[] lines) {
        for (String line : lines) {
            I.Log(type, tag, "\u2551 " + line);
        }
    }

    private static String bodyToString(Request request) {
        try {
            Request copy = request.newBuilder().build();
            Buffer buffer = new Buffer();
            if (copy.body() == null) {
                return "";
            }
            copy.body().writeTo((BufferedSink)buffer);
            return Logger.getJsonString(buffer.readUtf8());
        }
        catch (IOException e) {
            return "{\"err\": \"" + e.getMessage() + "\"}";
        }
    }

    static String getJsonString(String msg) {
        String message;
        try {
            if (msg.startsWith("{")) {
                JSONObject jsonObject = new JSONObject(msg);
                message = jsonObject.toString(4);
            } else if (msg.startsWith("[")) {
                JSONArray jsonArray = new JSONArray(msg);
                message = jsonArray.toString(4);
            } else {
                message = msg;
            }
        }
        catch (JSONException e) {
            message = msg;
        }
        return message;
    }
}

