/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.zip;

import com.feilong.core.Validate;
import com.feilong.core.date.DateUtil;
import com.feilong.io.IOWriteUtil;
import com.feilong.tools.slf4j.Slf4jUtil;
import com.feilong.zip.UnzipHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUnzipHandler
implements UnzipHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractUnzipHandler.class);

    @Override
    public void unzip(String unZipFilePath, String outputDirectory) {
        Validate.notBlank(unZipFilePath, "unZipFilePath can't be blank!", new Object[0]);
        Validate.notBlank(outputDirectory, "outputDirectory can't be blank!", new Object[0]);
        Date beginDate = DateUtil.now();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("begin unzip:[{}] to outputDirectory:[{}]", (Object)unZipFilePath, (Object)outputDirectory);
        }
        try {
            this.handle(unZipFilePath, outputDirectory);
        }
        catch (IOException e) {
            String message = Slf4jUtil.format("unZipFilePath:[{}],outputDirectory:[{}]", unZipFilePath, outputDirectory);
            throw new UncheckedIOException(message, e);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("use time:[{}],end unzip:[{}],outputDirectory:[{}]", new Object[]{DateUtil.formatDuration(beginDate), unZipFilePath, outputDirectory});
        }
    }

    protected abstract void handle(String var1, String var2) throws IOException;

    protected static void write(String zipEntryName, InputStream inputStream, String outputDirectory) {
        IOWriteUtil.write(inputStream, outputDirectory, zipEntryName);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("unzip [{}] to [{}]", (Object)zipEntryName, (Object)(outputDirectory + File.separator + zipEntryName));
        }
    }
}

