/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.xml;

import com.feilong.core.Validate;
import com.feilong.core.Validator;
import com.feilong.core.util.MapUtil;
import com.feilong.formatter.FormatterUtil;
import com.feilong.json.JsonUtil;
import com.feilong.xml.FeilongDocumentBuilder;
import com.feilong.xml.Hook;
import com.feilong.xml.TransformerBuilder;
import com.feilong.xml.UncheckedXmlParseException;
import com.feilong.xml.XPathUtil;
import com.feilong.xml.xstream.XStreamBuilder;
import com.feilong.xml.xstream.XStreamConfig;
import com.feilong.xml.xstream.XStreamConfigBuilder;
import com.thoughtworks.xstream.XStream;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlUtil.class);

    private XmlUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static Map<String, String> getNodeNameAndStringValueMap(Object xml, String xpathExpression) {
        return XmlUtil.getNodeMap(xml, xpathExpression, (map, node) -> map.put(node.getNodeName(), node.getTextContent()));
    }

    public static Map<String, String> getNodeAttributeValueAndStringValueMap(Object xml, String xpathExpression, String nodeAttributeName) {
        return XmlUtil.getNodeMap(xml, xpathExpression, (map, node) -> map.put(XmlUtil.getAttributeValue(node, nodeAttributeName), node.getTextContent()));
    }

    private static Map<String, String> getNodeMap(Object xml, String xpathExpression, Hook hook) {
        Document document = FeilongDocumentBuilder.buildDocument(xml);
        NodeList nodeList = (NodeList)XPathUtil.evaluate(document, xpathExpression, XPathConstants.NODESET);
        if (null == nodeList || 0 == nodeList.getLength()) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("use xpathExpression:[{}],from xml:[{}], can not find Node,return emptyMap", (Object)xpathExpression, (Object)XmlUtil.format(document));
            }
            return Collections.emptyMap();
        }
        Map<String, String> map = MapUtil.newLinkedHashMap();
        int j = nodeList.getLength();
        for (int i = 0; i < j; ++i) {
            Node node = nodeList.item(i);
            if (1 != node.getNodeType()) continue;
            hook.hook(map, node);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("nameAndValueMap:{}", (Object)FormatterUtil.formatToSimpleTable(map));
        }
        return map;
    }

    private static String getAttributeValue(Node node, String attributeName) {
        Validate.notNull(node, "node can't be null!", new Object[0]);
        Validate.notBlank(attributeName, "attributeName can't be null/empty!", new Object[0]);
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node currentNode = namedNodeMap.getNamedItem(attributeName);
        if (null != currentNode) {
            return currentNode.getNodeValue();
        }
        return "";
    }

    public static String format(String xml) {
        Document node = FeilongDocumentBuilder.buildDocument(xml);
        return XmlUtil.format(node);
    }

    private static String format(Node node) {
        try {
            StringWriter writer = new StringWriter();
            StreamResult streamResult = new StreamResult(writer);
            TransformerBuilder.DEFAULT_TRANSFORMER.transform(new DOMSource(node), streamResult);
            return ((Object)writer).toString();
        }
        catch (TransformerException e) {
            throw new UncheckedXmlParseException(e);
        }
    }

    public static <K, V> String toXML(Map<K, V> map, String rootElementName) {
        return XmlUtil.toXML(map, rootElementName, true);
    }

    public static <K, V> String toXML(Map<K, V> map, String rootElementName, boolean isPrettyPrint) {
        Validate.notEmpty(map, "map can't be null/empty!", new Object[0]);
        Validate.notBlank(rootElementName, "rootName can't be blank!", new Object[0]);
        XStreamConfig xStreamConfig = XStreamConfigBuilder.buildSimpleMapXStreamConfig(rootElementName, isPrettyPrint);
        if (map.getClass() != HashMap.class) {
            xStreamConfig.getAliasMap().put(rootElementName, map.getClass());
        }
        return XmlUtil.toXML(map, xStreamConfig);
    }

    public static String toXML(Object bean, XStreamConfig xStreamConfig) {
        Validate.notNull(bean, "bean can't be null!", new Object[0]);
        if (LOGGER.isDebugEnabled()) {
            String pattern = "class:[{}],bean:[{}],xStreamConfig:[{}]";
            LOGGER.debug(pattern, new Object[]{bean.getClass().getSimpleName(), JsonUtil.format(bean), JsonUtil.format(xStreamConfig)});
        }
        XStream xstream = XStreamBuilder.build(xStreamConfig);
        return xstream.toXML(bean);
    }

    public static Map<String, String> toMap(String xml, String rootElementName) {
        Validate.notBlank(rootElementName, "rootElementName can't be blank!", new Object[0]);
        if (Validator.isNullOrEmpty(xml)) {
            return null;
        }
        return (Map)XmlUtil.toBean(xml, XStreamConfigBuilder.buildSimpleMapXStreamConfig(rootElementName));
    }

    public static <T> T toBean(String xml, Class<T> processAnnotationsType) {
        Validate.notNull(processAnnotationsType, "processAnnotationsType can't be blank!", new Object[0]);
        if (Validator.isNullOrEmpty(xml)) {
            return null;
        }
        return XmlUtil.toBean(xml, new XStreamConfig(processAnnotationsType));
    }

    public static <T> T toBean(String xml, XStreamConfig xStreamConfig) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("input params info,xml:[{}],xStreamConfig:[{}]", (Object)xml, (Object)JsonUtil.format(xStreamConfig));
        }
        if (Validator.isNullOrEmpty(xml)) {
            return null;
        }
        XStream xstream = XStreamBuilder.build(xStreamConfig);
        return (T)xstream.fromXML(xml);
    }
}

