/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.xml;

import com.feilong.core.CharsetType;
import com.feilong.core.Validate;
import com.feilong.io.InputStreamUtil;
import com.feilong.lib.lang3.StringUtils;
import com.feilong.xml.UncheckedXmlParseException;
import com.feilong.xml.XXEUtil;
import java.io.File;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

class FeilongDocumentBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeilongDocumentBuilder.class);
    private static final DocumentBuilder DEFAULT_DOCUMENTBUILDER = FeilongDocumentBuilder.buildDefaultDocumentBuilder();

    private FeilongDocumentBuilder() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    static Document buildDocument(Object xml) {
        Validate.notNull(xml, "xml can't be null!", new Object[0]);
        if (xml instanceof String) {
            Validate.notBlank((String)xml, "xmlString can't be blank!", new Object[0]);
        }
        if (xml instanceof File && !((File)xml).exists()) {
            throw new IllegalArgumentException(((File)xml).getPath() + "file not exits");
        }
        try {
            if (xml instanceof String) {
                String xmlString = StringUtils.trim((String)xml);
                if (FeilongDocumentBuilder.isXmlString(xmlString)) {
                    InputStream inputStream = InputStreamUtil.newByteArrayInputStream(xmlString, CharsetType.UTF8);
                    return DEFAULT_DOCUMENTBUILDER.parse(inputStream);
                }
                LOGGER.debug("will parse use uri:[{}] for document", (Object)xmlString);
                return DEFAULT_DOCUMENTBUILDER.parse(xmlString);
            }
            if (xml instanceof File) {
                return DEFAULT_DOCUMENTBUILDER.parse((File)xml);
            }
            if (xml instanceof InputStream) {
                return DEFAULT_DOCUMENTBUILDER.parse((InputStream)xml);
            }
            throw new UnsupportedOperationException("xml:[" + xml + "] not support!");
        }
        catch (Exception e) {
            throw new UncheckedXmlParseException("input xml:" + xml, e);
        }
    }

    private static boolean isXmlString(String xmlString) {
        return xmlString.startsWith("<");
    }

    private static DocumentBuilder buildDefaultDocumentBuilder() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        XXEUtil.disableXXE(documentBuilderFactory);
        try {
            return documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new UncheckedXmlParseException(e);
        }
    }
}

