/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.tools.mobile;

import com.feilong.core.Validate;
import com.feilong.core.lang.StringUtil;

public final class MobileUtil {
    private static final String DEFAULT_MASK = "*";

    private MobileUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static String getMobileNumberHided(String mobileNumber) {
        return MobileUtil.getMobileNumberHided(mobileNumber, 4);
    }

    public static String getMobileNumberHided(String mobileNo, int count) {
        Validate.notBlank(mobileNo, "mobileNo can't be null/empty!", new Object[0]);
        Validate.isTrue(count >= 0, "the param count must >=0", new Object[0]);
        if (mobileNo.length() <= 3) {
            return mobileNo;
        }
        if (0 == count) {
            return mobileNo;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(MobileUtil.getMobileNumberSegment(mobileNo));
        for (int i = 0; i < count; ++i) {
            sb.append(DEFAULT_MASK);
        }
        int lastLenth = 8 - count;
        sb.append(StringUtil.substringLast(mobileNo, lastLenth));
        return sb.toString();
    }

    public static String getMobileNumberSegment(String mobileNumber) {
        Validate.notBlank(mobileNumber, "mobileNumber can't be blank!", new Object[0]);
        return mobileNumber.substring(0, 3);
    }
}

