/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.template;

import com.feilong.core.Validate;
import com.feilong.core.bean.ConvertUtil;
import com.feilong.core.util.ResourceBundleUtil;
import com.feilong.json.JsonUtil;
import java.util.Properties;
import org.apache.velocity.app.VelocityEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VelocityEngineBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(VelocityEngineBuilder.class);

    private VelocityEngineBuilder() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    static VelocityEngine build(String configFileInClassPath) {
        Validate.notBlank(configFileInClassPath, "configFileInClassPath can't be blank!", new Object[0]);
        Properties properties = ResourceBundleUtil.toProperties(ResourceBundleUtil.getResourceBundle(configFileInClassPath));
        String message = "can't load [%s],this properties is use for init velocityEngine,Please make sure that the location of the file path";
        Validate.notEmpty(properties, message, configFileInClassPath);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("will use [{}] init velocity, properties:{}", (Object)configFileInClassPath, (Object)JsonUtil.format(ConvertUtil.toMap(properties)));
        }
        VelocityEngine velocityEngine = new VelocityEngine();
        velocityEngine.init(properties);
        return velocityEngine;
    }
}

