/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.taglib.display.sensitive;

import com.feilong.core.bean.ConvertUtil;
import com.feilong.core.lang.EnumUtil;
import com.feilong.lib.lang3.StringUtils;

public enum SensitiveType {
    MOBILE("mobile"){

        @Override
        protected Integer[] getLeftAndRightNoMaskLengths(String value) {
            return ConvertUtil.toArray(3, 4);
        }
    }
    ,
    CHINESENAME("CHINESENAME"){

        @Override
        protected Integer[] getLeftAndRightNoMaskLengths(String value) {
            return ConvertUtil.toArray(1, 0);
        }

        @Override
        protected boolean isNoNeedMask(String value) {
            return value.length() == 1;
        }
    }
    ,
    ADDRESS("ADDRESS"){

        @Override
        protected Integer[] getLeftAndRightNoMaskLengths(String value) {
            return ConvertUtil.toArray(6, 0);
        }

        @Override
        protected boolean isNoNeedMask(String value) {
            return value.length() <= 6;
        }
    }
    ,
    EMAIL("EMAIL"){

        @Override
        protected Integer[] getLeftAndRightNoMaskLengths(String value) {
            int length = value.length();
            int index = StringUtils.indexOf((CharSequence)value, 64);
            if (2 <= index && index <= 4) {
                return ConvertUtil.toArray(1, length - index);
            }
            if (5 <= index && index <= 6) {
                return ConvertUtil.toArray(1, length - index + 1);
            }
            return ConvertUtil.toArray(2, length - index + 2);
        }

        @Override
        protected boolean isNoNeedMask(String value) {
            int index = StringUtils.indexOf((CharSequence)value, 64);
            return index == -1 || index == 0 || index == 1;
        }
    };

    private String type;

    private SensitiveType(String type) {
        this.type = type;
    }

    protected abstract Integer[] getLeftAndRightNoMaskLengths(String var1);

    protected boolean isNoNeedMask(String value) {
        return false;
    }

    public static SensitiveType toSensitiveType(String type) {
        return EnumUtil.getEnumByPropertyValueIgnoreCase(SensitiveType.class, "type", type);
    }

    public String getType() {
        return this.type;
    }
}

