/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.taglib.display.httpconcat.handler;

import com.feilong.core.Validator;
import com.feilong.core.bean.ConvertUtil;
import com.feilong.core.bean.ToStringConfig;
import com.feilong.taglib.display.httpconcat.command.HttpConcatParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConcatLinkResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConcatLinkResolver.class);

    private ConcatLinkResolver() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static String resolver(List<String> itemSrcList, HttpConcatParam standardHttpConcatParam) {
        int itemSrcListSize = itemSrcList.size();
        if (itemSrcListSize == 1) {
            String itemSrc = itemSrcList.get(0);
            LOGGER.debug("itemSrcList:[{}], size==1,will generate primary [{}].", (Object)itemSrc, (Object)standardHttpConcatParam.getType());
            return ConcatLinkResolver.resolver(itemSrc, standardHttpConcatParam);
        }
        return ConcatLinkResolver.resolver("??" + ConvertUtil.toString(itemSrcList, ToStringConfig.IGNORE_NULL_OR_EMPTY_CONFIG), standardHttpConcatParam);
    }

    public static String resolverNoConcatLink(String itemSrc, HttpConcatParam standardHttpConcatParam) {
        return ConcatLinkResolver.resolver(itemSrc, standardHttpConcatParam);
    }

    private static String resolver(String appendContent, HttpConcatParam standardHttpConcatParam) {
        StringBuilder sb = new StringBuilder();
        sb.append(standardHttpConcatParam.getDomain());
        sb.append(standardHttpConcatParam.getRoot());
        sb.append(appendContent);
        ConcatLinkResolver.appendVersion(standardHttpConcatParam.getVersion(), sb);
        return sb.toString();
    }

    private static void appendVersion(String version, StringBuilder sb) {
        if (Validator.isNotNullOrEmpty(version)) {
            sb.append("?");
            sb.append(version);
        } else {
            LOGGER.warn("HttpConcatParam version isNullOrEmpty,suggest you should set version value,StringBuilder info:[{}]", (Object)sb);
        }
    }
}

