/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.taglib.display.httpconcat.builder;

import com.feilong.core.lang.ObjectUtil;
import com.feilong.core.text.MessageFormatUtil;
import com.feilong.json.JsonUtil;
import com.feilong.lib.collection4.ListUtils;
import com.feilong.lib.lang3.BooleanUtils;
import com.feilong.taglib.display.httpconcat.builder.HttpConcatGlobalConfigBuilder;
import com.feilong.taglib.display.httpconcat.builder.HttpConcatParamBuilder;
import com.feilong.taglib.display.httpconcat.builder.TemplateFactory;
import com.feilong.taglib.display.httpconcat.command.HttpConcatParam;
import com.feilong.taglib.display.httpconcat.handler.ConcatLinkResolver;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResultBuilder.class);

    private ResultBuilder() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static String build(List<String> itemSrcList, HttpConcatParam httpConcatParam) {
        HttpConcatParam standardHttpConcatParam = HttpConcatParamBuilder.standardHttpConcatParam(itemSrcList, httpConcatParam);
        boolean concatSupport = ResultBuilder.concatSupport(httpConcatParam);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("after standard info:[{}],itemSrcList:[{}],concatSupport:[{}]", new Object[]{JsonUtil.format(standardHttpConcatParam), JsonUtil.format(itemSrcList), concatSupport});
        }
        String template = TemplateFactory.getTemplate(standardHttpConcatParam.getType());
        if (concatSupport) {
            return ResultBuilder.handlerConcat(itemSrcList, template, standardHttpConcatParam);
        }
        return ResultBuilder.handlerNoConcat(itemSrcList, template, standardHttpConcatParam);
    }

    private static String handlerConcat(List<String> itemSrcList, String template, HttpConcatParam standardHttpConcatParam) {
        Integer autoPartitionSize = HttpConcatGlobalConfigBuilder.GLOBAL_CONFIG.getAutoPartitionSize();
        if (null == autoPartitionSize || itemSrcList.size() <= autoPartitionSize) {
            return MessageFormatUtil.format(template, ConcatLinkResolver.resolver(itemSrcList, standardHttpConcatParam));
        }
        List<List<String>> groupList = ListUtils.partition(itemSrcList, autoPartitionSize);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < groupList.size(); ++i) {
            sb.append("<!-- HttpConcatTag,auto partition [" + (i + 1) + "] -->");
            sb.append(System.lineSeparator());
            sb.append(MessageFormatUtil.format(template, ConcatLinkResolver.resolver(groupList.get(i), standardHttpConcatParam)));
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }

    private static String handlerNoConcat(List<String> itemSrcList, String template, HttpConcatParam standardHttpConcatParam) {
        StringBuilder sb = new StringBuilder();
        for (String itemSrc : itemSrcList) {
            sb.append(MessageFormatUtil.format(template, ConcatLinkResolver.resolverNoConcatLink(itemSrc, standardHttpConcatParam)));
        }
        return sb.toString();
    }

    private static boolean concatSupport(HttpConcatParam httpConcatParam) {
        return ObjectUtil.defaultIfNull(httpConcatParam.getHttpConcatSupport(), BooleanUtils.toBoolean(HttpConcatGlobalConfigBuilder.GLOBAL_CONFIG.getHttpConcatSupport()));
    }
}

