/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.taglib.display.breadcrumb;

import com.feilong.core.Validator;
import com.feilong.taglib.AbstractStartWriteContentTag;
import com.feilong.taglib.display.breadcrumb.BreadCrumbUtil;
import com.feilong.taglib.display.breadcrumb.command.BreadCrumbEntity;
import com.feilong.taglib.display.breadcrumb.command.BreadCrumbParams;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BreadCrumbTag
extends AbstractStartWriteContentTag {
    private static final long serialVersionUID = -8596553099620845748L;
    private static final Logger LOGGER = LoggerFactory.getLogger(BreadCrumbTag.class);
    private List<BreadCrumbEntity<Object>> breadCrumbEntityList;
    private String urlPrefix = "";
    private String connector = ">";
    private String vmPath = "velocity/feilong-default-breadCrumb.vm";

    @Override
    protected Object buildContent(HttpServletRequest request) {
        List opBreadCrumbEntityList = this.constructBreadCrumbEntityList();
        if (Validator.isNullOrEmpty(opBreadCrumbEntityList)) {
            LOGGER.warn("breadCrumbEntityList is NullOrEmpty!!,return empty!!");
            return "";
        }
        BreadCrumbParams breadCrumbParams = new BreadCrumbParams();
        breadCrumbParams.setBreadCrumbEntityList(opBreadCrumbEntityList);
        breadCrumbParams.setConnector(this.connector);
        breadCrumbParams.setVmPath(this.vmPath);
        breadCrumbParams.setUrlPrefix(this.urlPrefix);
        return BreadCrumbUtil.getBreadCrumbContent(breadCrumbParams);
    }

    protected List<BreadCrumbEntity<Object>> constructBreadCrumbEntityList() {
        return this.breadCrumbEntityList;
    }

    public void setConnector(String connector) {
        this.connector = connector;
    }

    public void setBreadCrumbEntityList(List<BreadCrumbEntity<Object>> breadCrumbEntityList) {
        this.breadCrumbEntityList = breadCrumbEntityList;
    }

    public void setVmPath(String vmPath) {
        this.vmPath = vmPath;
    }

    public void setUrlPrefix(String urlPrefix) {
        this.urlPrefix = urlPrefix;
    }

    public String getUrlPrefix() {
        return this.urlPrefix;
    }

    public String getConnector() {
        return this.connector;
    }

    public String getVmPath() {
        return this.vmPath;
    }
}

