/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.taglib;

import com.feilong.core.Validate;
import com.feilong.core.Validator;
import javax.servlet.jsp.PageContext;

public final class TagUtils {
    public static final String SCOPE_PAGE = "page";
    public static final String SCOPE_REQUEST = "request";
    public static final String SCOPE_SESSION = "session";
    public static final String SCOPE_APPLICATION = "application";

    private TagUtils() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static int getScope(String scope) {
        Validate.notBlank(scope, "scope can't be blank!", new Object[0]);
        if (scope.equalsIgnoreCase(SCOPE_REQUEST)) {
            return 2;
        }
        if (scope.equalsIgnoreCase(SCOPE_SESSION)) {
            return 3;
        }
        if (scope.equalsIgnoreCase(SCOPE_APPLICATION)) {
            return 4;
        }
        return 1;
    }

    public static <T> T findAttributeValue(PageContext pageContext, String attributeName, String scope) {
        Validate.notNull(pageContext, "pageContext can't be null!", new Object[0]);
        Validate.notBlank(attributeName, "attributeName can't be blank!", new Object[0]);
        if (Validator.isNullOrEmpty(scope)) {
            return (T)pageContext.findAttribute(attributeName);
        }
        return (T)pageContext.getAttribute(attributeName, TagUtils.getScope(scope));
    }
}

