/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.taglib;

import com.feilong.core.Validator;
import com.feilong.core.date.DateUtil;
import com.feilong.core.lang.ClassUtil;
import com.feilong.servlet.http.RequestUtil;
import com.feilong.taglib.BaseTag;
import com.feilong.taglib.CacheTag;
import com.feilong.taglib.SimpleTagStringCacheManager;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractWriteContentTag
extends BaseTag {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractWriteContentTag.class);
    private static final long serialVersionUID = 8215127553271356734L;

    AbstractWriteContentTag() {
    }

    protected void execute() {
        Date beginDate = DateUtil.now();
        HttpServletRequest request = this.getHttpServletRequest();
        Object writeContent = this.buildContentIfUseCache(request);
        if (null != writeContent) {
            this.print(writeContent);
        }
        if (LOGGER.isDebugEnabled()) {
            String buildExtraKeyInfoToLog = this.buildExtraKeyInfoToLog();
            String tagLog = Validator.isNullOrEmpty(buildExtraKeyInfoToLog) ? "" : "," + buildExtraKeyInfoToLog;
            String useTime = DateUtil.formatDuration(beginDate);
            LOGGER.debug("[{}],[{}]{},use time:[{}]", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), RequestUtil.getRequestURL(request), tagLog, useTime});
        }
    }

    protected Object buildContentIfUseCache(HttpServletRequest request) {
        Object contentFromCache;
        String cacheKey;
        Class<?> klass = ((Object)((Object)this)).getClass();
        boolean isCacheTag = ClassUtil.isAssignableFrom(CacheTag.class, klass);
        String string = cacheKey = !isCacheTag ? null : ((CacheTag)((Object)this)).buildCacheTagKey();
        if (isCacheTag && Validator.isNotNullOrEmpty(contentFromCache = SimpleTagStringCacheManager.get(cacheKey))) {
            return contentFromCache;
        }
        Object writeContent = this.buildContent(request);
        if (isCacheTag && Validator.isNotNullOrEmpty(writeContent)) {
            SimpleTagStringCacheManager.put(cacheKey, writeContent);
        }
        return writeContent;
    }

    protected abstract Object buildContent(HttpServletRequest var1);

    protected String buildExtraKeyInfoToLog() {
        return "";
    }

    protected void print(Object object) {
        JspWriter jspWriter = this.pageContext.getOut();
        try {
            jspWriter.print(object);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected void println(Object object) {
        JspWriter jspWriter = this.pageContext.getOut();
        try {
            jspWriter.println(object.toString());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

