/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.spring.expression;

import com.feilong.core.Validate;
import com.feilong.core.util.MapUtil;
import java.util.Map;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public final class SpelUtil {
    private static ExpressionParser expressionParser = new SpelExpressionParser();
    private static final Map<String, Expression> EXPRESSION_STRING_AND_EXPRESSION_MAP = MapUtil.newConcurrentHashMap();

    private SpelUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static <T> T getTemplateValue(String expressionString) {
        Validate.notBlank(expressionString, "expressionString can't be blank!", new Object[0]);
        Expression expression = SpelUtil.load(expressionString, ParserContext.TEMPLATE_EXPRESSION);
        return (T)expression.getValue();
    }

    public static <T> T getValue(String expressionString) {
        Validate.notBlank(expressionString, "expressionString can't be blank!", new Object[0]);
        Expression expression = SpelUtil.load(expressionString, null);
        return (T)expression.getValue();
    }

    public static <V, T> V getValue(String expressionString, T rootObject) {
        Validate.notBlank(expressionString, "expressionString can't be blank!", new Object[0]);
        if (null == rootObject) {
            return (V)SpelUtil.getValue(expressionString);
        }
        StandardEvaluationContext evaluationContext = new StandardEvaluationContext(rootObject);
        Expression expression = SpelUtil.load(expressionString, null);
        return (V)expression.getValue((EvaluationContext)evaluationContext);
    }

    private static Expression load(String expressionString, ParserContext context) {
        Expression expression = EXPRESSION_STRING_AND_EXPRESSION_MAP.get(expressionString);
        if (null != expression) {
            return expression;
        }
        expression = expressionParser.parseExpression(expressionString, context);
        EXPRESSION_STRING_AND_EXPRESSION_MAP.put(expressionString, expression);
        return expression;
    }
}

