/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.servlet.http.listener;

import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletRequestAttributeLoggingListener
implements ServletRequestAttributeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletRequestAttributeLoggingListener.class);

    public void attributeAdded(ServletRequestAttributeEvent servletRequestAttributeEvent) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("name:[{}],value:[{}] added to [servletRequest]", (Object)servletRequestAttributeEvent.getName(), servletRequestAttributeEvent.getValue());
        }
    }

    public void attributeRemoved(ServletRequestAttributeEvent servletRequestAttributeEvent) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("name:[{}],value:[{}] removed from [servletRequest]", (Object)servletRequestAttributeEvent.getName(), servletRequestAttributeEvent.getValue());
        }
    }

    public void attributeReplaced(ServletRequestAttributeEvent servletRequestAttributeEvent) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("name:[{}],value:[{}] replaced to [servletRequest]", (Object)servletRequestAttributeEvent.getName(), servletRequestAttributeEvent.getValue());
        }
    }
}

