/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.servlet.http.listener;

import com.feilong.core.Validator;
import com.feilong.json.JsonUtil;
import com.feilong.lib.lang3.ArrayUtils;
import com.feilong.servlet.ServletContextUtil;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletContextAttributeLoggingListener
implements ServletContextAttributeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletContextAttributeLoggingListener.class);

    public void attributeAdded(ServletContextAttributeEvent servletContextAttributeEvent) {
        if (LOGGER.isInfoEnabled()) {
            String name = servletContextAttributeEvent.getName();
            if (Validator.isNotNullOrEmpty(name) && ArrayUtils.contains(ServletContextUtil.EXCLUDE_KEYS, name)) {
                return;
            }
            LOGGER.info("name:[{}],value:[{}] added to [servletContext],now servletContext attribute:[{}] ", new Object[]{name, servletContextAttributeEvent.getValue(), ServletContextAttributeLoggingListener.buildAttributesLogMessage(servletContextAttributeEvent.getServletContext())});
        }
    }

    private static String buildAttributesLogMessage(ServletContext servletContext) {
        Map<String, Object> attributeMap = ServletContextUtil.getAttributeMap(servletContext);
        return JsonUtil.formatSimpleMap(attributeMap);
    }

    public void attributeRemoved(ServletContextAttributeEvent servletContextAttributeEvent) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("name:[{}],value:[{}] removed from [servletContext],now servletContext attribute:[{}] ", new Object[]{servletContextAttributeEvent.getName(), servletContextAttributeEvent.getValue(), ServletContextAttributeLoggingListener.buildAttributesLogMessage(servletContextAttributeEvent.getServletContext())});
        }
    }

    public void attributeReplaced(ServletContextAttributeEvent servletContextAttributeEvent) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("name:[{}],value:[{}] replaced to [servletContext],now servletContext attribute:[{}] ", new Object[]{servletContextAttributeEvent.getName(), servletContextAttributeEvent.getValue(), ServletContextAttributeLoggingListener.buildAttributesLogMessage(servletContextAttributeEvent.getServletContext())});
        }
    }
}

