/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.servlet.http.listener;

import com.feilong.json.JsonUtil;
import com.feilong.servlet.http.SessionUtil;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSessionAttributeLoggingListener
implements HttpSessionAttributeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpSessionAttributeLoggingListener.class);

    public void attributeAdded(HttpSessionBindingEvent httpSessionBindingEvent) {
        if (LOGGER.isDebugEnabled()) {
            HttpSession session = httpSessionBindingEvent.getSession();
            LOGGER.debug("name:[{}],value:[{}] added to [session],now session info:[{}] ", new Object[]{httpSessionBindingEvent.getName(), httpSessionBindingEvent.getValue(), JsonUtil.format(SessionUtil.getSessionInfoMapForLog(session))});
        }
    }

    public void attributeRemoved(HttpSessionBindingEvent httpSessionBindingEvent) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("name:[{}],value:[{}] removed from [session]", (Object)httpSessionBindingEvent.getName(), httpSessionBindingEvent.getValue());
        }
    }

    public void attributeReplaced(HttpSessionBindingEvent httpSessionBindingEvent) {
        if (LOGGER.isDebugEnabled()) {
            HttpSession session = httpSessionBindingEvent.getSession();
            LOGGER.debug("name:[{}],value:[{}] replaced to [session],now session info:[{}] ", new Object[]{httpSessionBindingEvent.getName(), httpSessionBindingEvent.getValue(), JsonUtil.format(SessionUtil.getSessionInfoMapForLog(session))});
        }
    }
}

