/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.servlet.http;

import com.feilong.core.CharsetType;
import com.feilong.core.Validate;
import com.feilong.core.Validator;
import com.feilong.core.bean.ConvertUtil;
import com.feilong.core.lang.StringUtil;
import com.feilong.core.util.EnumerationUtil;
import com.feilong.core.util.MapUtil;
import com.feilong.core.util.ResourceBundleUtil;
import com.feilong.core.util.SortUtil;
import com.feilong.io.ReaderUtil;
import com.feilong.json.JsonUtil;
import com.feilong.lib.lang3.StringUtils;
import com.feilong.servlet.http.RequestException;
import com.feilong.servlet.http.RequestLogBuilder;
import com.feilong.servlet.http.entity.RequestLogSwitch;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestUtil.class);
    private static final String REQUEST_BODY_SCOPE_ATTRIBUTE_NAME = RequestUtil.class.getName() + ".REQUEST_BODY";
    private static final String[] IP_HEADER_NAMES = StringUtil.tokenizeToStringArray(ResourceBundleUtil.getValue(ResourceBundleUtil.getResourceBundle("config/feilong-request-clientIP-headers"), "clientIP.headerNames", new Object[0]), ",");
    private static final String[] STATIC_RESOURCE_SUFFIX = StringUtil.tokenizeToStringArray(ResourceBundleUtil.getValue(ResourceBundleUtil.getResourceBundle("config/feilong-request-staticResourceSuffix"), "request.staticResourceSuffix", new Object[0]), ",");

    private RequestUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static boolean isStaticResource(String requestURI) {
        if (Validator.isNullOrEmpty(requestURI)) {
            return false;
        }
        if (!requestURI.contains(".")) {
            return false;
        }
        for (String uriSuffix : STATIC_RESOURCE_SUFFIX) {
            if (!StringUtils.endsWithIgnoreCase(requestURI, uriSuffix)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSupportMethod(String[] supportHttpMethods, String method) {
        Validate.notBlank(method, "method can't be blank!", new Object[0]);
        if (Validator.isNullOrEmpty(supportHttpMethods)) {
            return false;
        }
        for (String supportHttpMethod : supportHttpMethods) {
            if (!StringUtils.equalsIgnoreCase(supportHttpMethod, method)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsParam(HttpServletRequest request, String paramName) {
        Validate.notBlank(paramName, "paramName can't be null/empty!", new Object[0]);
        return EnumerationUtil.contains(request.getParameterNames(), paramName);
    }

    public static Map<String, String[]> getParameterMap(HttpServletRequest request) {
        return SortUtil.sortMapByKeyAsc(request.getParameterMap());
    }

    public static Map<String, String> getParameterSingleValueMap(HttpServletRequest request) {
        return MapUtil.toSingleValueMap(RequestUtil.getParameterMap(request));
    }

    public static Map<String, Object> getRequestInfoMapForLog(HttpServletRequest request) {
        return RequestUtil.getRequestInfoMapForLog(request, RequestLogSwitch.NORMAL);
    }

    public static Map<String, Object> getRequestInfoMapForLog(HttpServletRequest request, RequestLogSwitch requestLogSwitch) {
        return new RequestLogBuilder(request, requestLogSwitch).build();
    }

    public static <T> T getAttribute(HttpServletRequest request, String attributeName) {
        Validate.notBlank(attributeName, "attributeName can't be null/empty!", new Object[0]);
        return (T)request.getAttribute(attributeName);
    }

    public static <T> T getAttribute(HttpServletRequest request, String name, Class<T> klass) {
        T value = RequestUtil.getAttribute(request, name);
        return ConvertUtil.convert(value, klass);
    }

    public static String getRequestURL(HttpServletRequest request) {
        String forwardRequestUri = (String)RequestUtil.getAttribute(request, "javax.servlet.forward.request_uri");
        return Validator.isNotNullOrEmpty(forwardRequestUri) ? forwardRequestUri : request.getRequestURL().toString();
    }

    public static String getOriginatingServletPath(HttpServletRequest request) {
        String servletPath = (String)RequestUtil.getAttribute(request, "javax.servlet.forward.servlet_path");
        return Validator.isNotNullOrEmpty(servletPath) ? servletPath : request.getServletPath();
    }

    public static String getRequestFullURL(HttpServletRequest request, String charsetType) {
        String requestURL = RequestUtil.getRequestURL(request);
        String queryString = request.getQueryString();
        return Validator.isNullOrEmpty(queryString) ? requestURL : requestURL + "?" + RequestUtil.decodeISO88591String(queryString, charsetType);
    }

    @Deprecated
    public static String decodeISO88591String(String str, String charsetType) {
        return StringUtil.newString(StringUtil.getBytes(str, CharsetType.ISO_8859_1), charsetType);
    }

    public static String getServerRootWithContextPath(HttpServletRequest request) {
        String scheme = request.getScheme();
        int port = request.getServerPort() < 0 ? 80 : request.getServerPort();
        StringBuilder sb = new StringBuilder();
        sb.append(scheme);
        sb.append("://");
        sb.append(request.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            sb.append(':');
            sb.append(port);
        }
        sb.append(request.getContextPath());
        return sb.toString();
    }

    public static void forward(String path, HttpServletRequest request, HttpServletResponse response) {
        Validate.notNull(path, "path can't be null!", new Object[0]);
        LOGGER.debug("will forward to path:[{}]", (Object)path);
        try {
            RequestDispatcher requestDispatcher = request.getRequestDispatcher(path);
            requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (IOException | ServletException e) {
            throw new RequestException("when forward to:" + path, e);
        }
    }

    public static void include(String path, HttpServletRequest request, HttpServletResponse response) {
        Validate.notNull(path, "path can't be null!", new Object[0]);
        LOGGER.debug("will include to path:[{}]", (Object)path);
        try {
            RequestDispatcher requestDispatcher = request.getRequestDispatcher(path);
            requestDispatcher.include((ServletRequest)request, (ServletResponse)response);
        }
        catch (IOException | ServletException e) {
            throw new RequestException("when include:" + path, e);
        }
    }

    public static String getClientIp(HttpServletRequest request) {
        Map<String, String> map = MapUtil.newLinkedHashMap();
        for (String ipHeaderName : IP_HEADER_NAMES) {
            map.put(ipHeaderName, request.getHeader(ipHeaderName));
        }
        map.put("request.getRemoteAddr()", request.getRemoteAddr());
        return RequestUtil.getClientIp(map);
    }

    private static String getClientIp(Map<String, String> map) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("ips:{}", (Object)JsonUtil.format(map));
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String value = entry.getValue();
            if (Validator.isNullOrEmpty(value) || "unknown".equalsIgnoreCase(value)) continue;
            String[] ips = StringUtil.tokenizeToStringArray(value, ",");
            return ips[0];
        }
        return "";
    }

    public static String getHeaderUserAgent(HttpServletRequest request) {
        return request.getHeader("User-Agent");
    }

    public static String getHeaderReferer(HttpServletRequest request) {
        return request.getHeader("Referer");
    }

    public static String getHeaderOrigin(HttpServletRequest request) {
        return request.getHeader("origin");
    }

    public static boolean isWechatRequest(HttpServletRequest request) {
        String userAgent = RequestUtil.getHeaderUserAgent(request);
        if (Validator.isNullOrEmpty(userAgent)) {
            return false;
        }
        return userAgent.toLowerCase().contains("micromessenger");
    }

    public static boolean isAjaxRequest(HttpServletRequest request) {
        String header = request.getHeader("X-Requested-With");
        return Validator.isNotNullOrEmpty(header) && header.equalsIgnoreCase("XMLHttpRequest");
    }

    public static boolean isNotAjaxRequest(HttpServletRequest request) {
        return !RequestUtil.isAjaxRequest(request);
    }

    public static Map<String, Object> getAttributeMap(HttpServletRequest request) {
        Enumeration attributeNames = request.getAttributeNames();
        if (Validator.isNullOrEmpty(attributeNames)) {
            return Collections.emptyMap();
        }
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        while (attributeNames.hasMoreElements()) {
            String name = (String)attributeNames.nextElement();
            map.put(name, RequestUtil.getAttribute(request, name));
        }
        return map;
    }

    public static String getParameter(HttpServletRequest request, String paramName) {
        return request.getParameter(paramName);
    }

    public static String getRequestBody(HttpServletRequest request) {
        String requestBodyInRequestScope = (String)RequestUtil.getAttribute(request, REQUEST_BODY_SCOPE_ATTRIBUTE_NAME);
        if (null != requestBodyInRequestScope) {
            return requestBodyInRequestScope;
        }
        String requestBody = RequestUtil.parseBody(request);
        if (null != requestBody) {
            request.setAttribute(REQUEST_BODY_SCOPE_ATTRIBUTE_NAME, (Object)requestBody);
        }
        return requestBody;
    }

    private static String parseBody(HttpServletRequest request) {
        try {
            BufferedReader reader = request.getReader();
            return ReaderUtil.toString(reader);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

