/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.servlet.http;

import com.feilong.core.CharsetType;
import com.feilong.core.Validator;
import com.feilong.core.bean.ConvertUtil;
import com.feilong.core.lang.ObjectUtil;
import com.feilong.core.net.ParamUtil;
import com.feilong.core.util.MapUtil;
import com.feilong.lib.lang3.builder.Builder;
import com.feilong.servlet.http.CookieUtil;
import com.feilong.servlet.http.RequestUtil;
import com.feilong.servlet.http.entity.RequestIdentity;
import com.feilong.servlet.http.entity.RequestLogSwitch;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;

class RequestLogBuilder
implements Builder<Map<String, Object>> {
    private final HttpServletRequest request;
    private final RequestLogSwitch requestLogSwitch;

    public RequestLogBuilder(HttpServletRequest request, RequestLogSwitch requestLogSwitch) {
        this.request = request;
        this.requestLogSwitch = requestLogSwitch;
    }

    @Override
    public Map<String, Object> build() {
        RequestLogSwitch opRequestLogSwitch = ObjectUtil.defaultIfNull(this.requestLogSwitch, RequestLogSwitch.NORMAL);
        Map<String, Object> map = MapUtil.newLinkedHashMap();
        String clientIp = this.getClientIP(opRequestLogSwitch);
        if (opRequestLogSwitch.getShowFullURL()) {
            map.put("requestFullURL", RequestUtil.getRequestFullURL(this.request, CharsetType.UTF8));
        }
        if (opRequestLogSwitch.getShowMethod()) {
            map.put("requestMethod", this.request.getMethod());
        }
        if (opRequestLogSwitch.getShowParams()) {
            MapUtil.putIfValueNotNullOrEmpty(map, "parameters", RequestUtil.getParameterMap(this.request));
        }
        if (opRequestLogSwitch.getShowIdentity()) {
            RequestIdentity requestIdentity = new RequestIdentity();
            requestIdentity.setClientIP(clientIp);
            requestIdentity.setUserAgent(RequestUtil.getHeaderUserAgent(this.request));
            requestIdentity.setSessionId(RequestLogBuilder.getSessionId(this.request));
            map.put("requestIdentity", requestIdentity);
        }
        if (opRequestLogSwitch.getShowHeaders()) {
            map.put("headerInfos", this.getHeaderMap());
        }
        if (opRequestLogSwitch.getShowCookies()) {
            MapUtil.putIfValueNotNullOrEmpty(map, "cookieInfos", CookieUtil.getCookieMap(this.request));
        }
        if (opRequestLogSwitch.getShowURLs()) {
            map.put("urlInfos", this.buildURLInfosMap());
        }
        if (opRequestLogSwitch.getShowElses()) {
            map.put("elseInfos", this.buildElseMap());
        }
        if (opRequestLogSwitch.getShowIPs()) {
            map.put("ipInfos", this.buildIpsMap(clientIp));
        }
        if (opRequestLogSwitch.getShowPorts()) {
            map.put("portInfos", this.buildPortsMap());
        }
        if (opRequestLogSwitch.getShowErrors()) {
            MapUtil.putIfValueNotNullOrEmpty(map, "errorInfos", RequestLogBuilder.getErrorMap(this.request));
        }
        if (opRequestLogSwitch.getShowForwardInfos()) {
            MapUtil.putIfValueNotNullOrEmpty(map, "forwardInfos", RequestLogBuilder.getForwardMap(this.request));
        }
        if (opRequestLogSwitch.getShowIncludeInfos()) {
            MapUtil.putIfValueNotNullOrEmpty(map, "includeInfos", RequestLogBuilder.getIncludeMap(this.request));
        }
        return map;
    }

    private String getClientIP(RequestLogSwitch opRequestLogSwitch) {
        return opRequestLogSwitch.getShowIdentity() || opRequestLogSwitch.getShowIPs() ? RequestUtil.getClientIp(this.request) : null;
    }

    private Map<String, String> buildPortsMap() {
        TreeMap<String, String> aboutPortMap = new TreeMap<String, String>();
        aboutPortMap.put("request.getLocalPort()", "" + this.request.getLocalPort());
        aboutPortMap.put("request.getRemotePort()", "" + this.request.getRemotePort());
        aboutPortMap.put("request.getServerPort()", "" + this.request.getServerPort());
        return aboutPortMap;
    }

    private Map<String, String> buildIpsMap(String clientIP) {
        TreeMap<String, String> aboutIPMap = new TreeMap<String, String>();
        aboutIPMap.put("request.getLocalAddr()", this.request.getLocalAddr());
        aboutIPMap.put("request.getRemoteAddr()", this.request.getRemoteAddr());
        aboutIPMap.put("request.getRemoteHost()", this.request.getRemoteHost());
        aboutIPMap.put("request.getServerName()", this.request.getServerName());
        aboutIPMap.put("getClientIp", clientIP);
        return aboutIPMap;
    }

    private Map<String, Object> buildElseMap() {
        Map<String, Object> aboutElseMap = MapUtil.newLinkedHashMap();
        aboutElseMap.put("request.getScheme()", this.request.getScheme());
        aboutElseMap.put("request.getProtocol()", this.request.getProtocol());
        aboutElseMap.put("request.getAuthType()", this.request.getAuthType());
        aboutElseMap.put("request.getCharacterEncoding()", this.request.getCharacterEncoding());
        aboutElseMap.put("request.getContentType()", "" + this.request.getContentType());
        aboutElseMap.put("request.getContentLength()", "" + this.request.getContentLength());
        aboutElseMap.put("request.getLocale()", "" + this.request.getLocale());
        aboutElseMap.put("request.getLocalName()", this.request.getLocalName());
        aboutElseMap.put("request.getRemoteUser()", this.request.getRemoteUser());
        aboutElseMap.put("request.isRequestedSessionIdFromCookie()", this.request.isRequestedSessionIdFromCookie());
        aboutElseMap.put("request.isRequestedSessionIdFromURL()", this.request.isRequestedSessionIdFromURL());
        aboutElseMap.put("request.isRequestedSessionIdValid()", this.request.isRequestedSessionIdValid());
        aboutElseMap.put("request.isSecure()", this.request.isSecure());
        aboutElseMap.put("request.getUserPrincipal()", this.request.getUserPrincipal());
        return aboutElseMap;
    }

    private static String getSessionId(HttpServletRequest request) {
        return CookieUtil.getCookieValue(request, "JSESSIONID");
    }

    private static Map<String, String> getForwardMap(HttpServletRequest request) {
        String[] array = new String[]{"javax.servlet.forward.context_path", "javax.servlet.forward.request_uri", "javax.servlet.forward.servlet_path", "javax.servlet.forward.path_info", "javax.servlet.forward.query_string"};
        return RequestLogBuilder.getAttributeMapIfValueNotNull(request, array);
    }

    private static Map<String, String> getIncludeMap(HttpServletRequest request) {
        String[] array = new String[]{"javax.servlet.include.context_path", "javax.servlet.include.path_info", "javax.servlet.include.query_string", "javax.servlet.include.request_uri", "javax.servlet.include.servlet_path"};
        return RequestLogBuilder.getAttributeMapIfValueNotNull(request, array);
    }

    private static Map<String, String> getErrorMap(HttpServletRequest request) {
        String[] array = new String[]{"javax.servlet.error.status_code", "javax.servlet.error.request_uri", "javax.servlet.error.exception", "javax.servlet.error.exception_type", "javax.servlet.error.message", "javax.servlet.error.servlet_name"};
        return RequestLogBuilder.getAttributeMapIfValueNotNull(request, array);
    }

    private static Map<String, String> getAttributeMapIfValueNotNull(HttpServletRequest request, String ... attributeNames) {
        Map<String, String> map = MapUtil.newLinkedHashMap(attributeNames.length);
        for (String attributeName : attributeNames) {
            MapUtil.putIfValueNotNull(map, attributeName, ConvertUtil.toString(RequestUtil.getAttribute(request, attributeName)));
        }
        return map;
    }

    private Map<String, String> buildURLInfosMap() {
        Map<String, String> map = MapUtil.newLinkedHashMap();
        map.put("request.getContextPath()", this.request.getContextPath());
        map.put("request.getServletPath()", this.request.getServletPath());
        map.put("request.getPathInfo()", this.request.getPathInfo());
        map.put("request.getPathTranslated()", this.request.getPathTranslated());
        map.put("request.getRequestURI()", this.request.getRequestURI());
        map.put("request.getRequestURL()", "" + this.request.getRequestURL());
        map.put("request.getQueryString()", this.request.getQueryString());
        map.put("getQueryStringLog", this.getQueryStringLog());
        return map;
    }

    private Map<String, String> getHeaderMap() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        Enumeration headerNames = this.request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            map.put(name, this.request.getHeader(name));
        }
        return map;
    }

    private String getQueryStringLog() {
        Map<String, String[]> map;
        String method = this.request.getMethod();
        if ("post".equalsIgnoreCase(method) && Validator.isNotNullOrEmpty(map = RequestUtil.getParameterMap(this.request))) {
            return ParamUtil.toQueryStringUseArrayValueMap(map);
        }
        return this.request.getQueryString();
    }
}

