/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.security.oneway;

import com.feilong.core.Validate;
import com.feilong.core.lang.StringUtil;
import com.feilong.lib.codec.digest.DigestUtils;
import com.feilong.security.ByteUtil;
import com.feilong.security.EncryptionException;
import com.feilong.security.oneway.OnewayType;
import com.feilong.tools.slf4j.Slf4jUtil;
import java.io.File;
import java.io.FileInputStream;
import java.security.MessageDigest;

final class OnewayEncryption {
    private OnewayEncryption() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static String encode(OnewayType onewayType, String origin) {
        byte[] inputBytes = StringUtil.getBytes(origin);
        return OnewayEncryption.encode(onewayType, inputBytes);
    }

    public static String encode(OnewayType onewayType, String origin, String charsetName) {
        byte[] inputBytes = StringUtil.getBytes(origin, charsetName);
        return OnewayEncryption.encode(onewayType, inputBytes);
    }

    public static String encode(OnewayType onewayType, byte[] inputBytes) {
        MessageDigest messageDigest = OnewayEncryption.getMessageDigest(onewayType);
        byte[] bs = messageDigest.digest(inputBytes);
        return ByteUtil.bytesToHexStringLowerCase(bs);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String encodeFile(OnewayType onewayType, String filePath) {
        Validate.notBlank(filePath, "filePath can't be null/empty!", new Object[0]);
        File file = new File(filePath);
        Validate.isTrue(file.exists(), "file:" + filePath + " don't exists!", new Object[0]);
        Validate.isTrue(file.isFile(), filePath + " is not a File!", new Object[0]);
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            MessageDigest messageDigest = OnewayEncryption.getMessageDigest(onewayType);
            byte[] bytes = DigestUtils.updateDigest(messageDigest, fileInputStream).digest();
            String string = ByteUtil.bytesToHexStringLowerCase(bytes);
            return string;
        }
        catch (Exception e) {
            throw new EncryptionException(Slf4jUtil.format("onewayType:[{}],filePath:[{}]", new Object[]{onewayType, filePath}), e);
        }
    }

    private static final MessageDigest getMessageDigest(OnewayType onewayType) {
        Validate.notNull(onewayType, "onewayType can't be null!", new Object[0]);
        return DigestUtils.getDigest(onewayType.getAlgorithm());
    }
}

