/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.net.mail.util;

import com.feilong.core.Validator;
import com.feilong.core.lang.ArrayUtil;
import com.feilong.core.lang.StringUtil;
import com.feilong.core.util.CollectionsUtil;
import com.feilong.core.util.MapUtil;
import com.feilong.io.FileUtil;
import com.feilong.net.mail.entity.MailInfo;
import com.feilong.net.mail.exception.MailException;
import com.feilong.net.mail.util.MimeType;
import com.feilong.tools.slf4j.Slf4jUtil;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.InternetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessageUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageUtil.class);

    private MessageUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static final List<MailInfo> toMailInfoList(Message[] messages) throws MessagingException {
        int messagesLength = messages.length;
        LOGGER.info("messages length:[{}]", (Object)messagesLength);
        List<MailInfo> list = CollectionsUtil.newArrayList();
        for (int i = 0; i < messagesLength; ++i) {
            Message message = messages[i];
            String format = StringUtil.format("%0" + String.valueOf(messagesLength).length() + "d", i + 1);
            String pattern = "[{}/{}] start convert Message to MailInfo,from:[{}],contentType:[{}],subject:[{}]";
            LOGGER.info(pattern, new Object[]{format, messagesLength, MessageUtil.getFromAddress(message), message.getContentType(), message.getSubject()});
            list.add(MessageUtil.toMailInfoList(message));
        }
        return list;
    }

    private static final MailInfo toMailInfoList(Message message) throws MessagingException {
        String from = MessageUtil.getFromAddress(message);
        String subject = message.getSubject();
        try {
            MailInfo mailInfo = new MailInfo();
            mailInfo.setFrom(from);
            mailInfo.setContentType(message.getContentType());
            mailInfo.setContent(MessageUtil.getContent((Part)message));
            mailInfo.setReceivedDate(message.getReceivedDate());
            mailInfo.setRecipients(MessageUtil.toRecipients(message.getAllRecipients()));
            mailInfo.setSentDate(message.getSentDate());
            mailInfo.setSize(FileUtil.formatSize(message.getSize()));
            mailInfo.setSubject(subject);
            return mailInfo;
        }
        catch (Exception e) {
            throw new MailException(Slf4jUtil.format("from:[{}],subject:[{}]", from, subject), e);
        }
    }

    private static String[] toRecipients(Address[] allRecipients) {
        if (Validator.isNullOrEmpty(allRecipients)) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        int length = allRecipients.length;
        String[] recipients = new String[length];
        int j = length;
        for (int i = 0; i < j; ++i) {
            recipients[i] = MessageUtil.getAddress(allRecipients[i]);
        }
        return recipients;
    }

    public static final Map<String, Object> getMapForLog(Message message) {
        try {
            Map<String, Object> map = MapUtil.newLinkedHashMap();
            map.put("from", MessageUtil.getFromAddress(message));
            map.put("sentDate", message.getSentDate());
            map.put("size", FileUtil.formatSize(message.getSize()));
            map.put("subject", message.getSubject());
            map.put("allHeaders", message.getAllHeaders());
            map.put("allRecipients", message.getAllRecipients());
            map.put("contentType", message.getContentType());
            map.put("description", message.getDescription());
            map.put("getFileName", message.getFileName());
            map.put("getFlags", message.getFlags().toString());
            map.put("getFolder", message.getFolder().getFullName());
            map.put("getLineCount", message.getLineCount());
            map.put("getMessageNumber", message.getMessageNumber());
            map.put("getReceivedDate", message.getReceivedDate());
            map.put("getReplyTo", message.getReplyTo());
            return map;
        }
        catch (Exception e) {
            throw new MailException(e);
        }
    }

    private static String getFromAddress(Message message) {
        try {
            Address[] from = message.getFrom();
            return MessageUtil.getAddress(from[0]);
        }
        catch (Exception e) {
            throw new MailException(e);
        }
    }

    private static String getAddress(Address address) {
        InternetAddress internetAddress = (InternetAddress)address;
        return internetAddress.getAddress();
    }

    private static String getContent(Part part) {
        try {
            if (part.isMimeType("text/*")) {
                return MessageUtil.doWithTextAll(part);
            }
            if (part.isMimeType("multipart/*")) {
                return MessageUtil.doWithMultipartAll(part);
            }
            if (part.isMimeType("message/rfc822")) {
                LOGGER.debug("content mimeType:[{}],match with:--->[{}]", (Object)part.getContentType(), (Object)"message/rfc822");
                return MessageUtil.getContent((Part)part.getContent());
            }
            LOGGER.debug("part getContentType:{}", (Object)part.getContentType());
            return null;
        }
        catch (Exception e) {
            throw new MailException(e);
        }
    }

    private static String doWithTextAll(Part part) throws MessagingException, IOException {
        Object content = part.getContent();
        String pattern = "content mimeType:[{}],match with:--->[{}],getContent value:[{}]";
        LOGGER.debug(pattern, new Object[]{part.getContentType(), "text/*", content});
        return (String)content;
    }

    private static String doWithMultipartAll(Part part) throws IOException, MessagingException {
        Multipart multipart = (Multipart)part.getContent();
        int count = multipart.getCount();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("content mimeType:[{}],match with:--->[{}],count:[{}]", new Object[]{multipart.getContentType(), "multipart/*", count});
        }
        boolean alternativeFlag = part.isMimeType("multipart/alternative");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            BodyPart bodyPart = multipart.getBodyPart(i);
            if (!MessageUtil.isNeedAppend(bodyPart, alternativeFlag)) continue;
            sb.append(MessageUtil.getContent((Part)bodyPart));
        }
        return sb.toString();
    }

    private static boolean isNeedAppend(BodyPart bodyPart, boolean alternativeFlag) throws MessagingException {
        if (!alternativeFlag) {
            return true;
        }
        return bodyPart.isMimeType(MimeType.TEXT_HTML);
    }
}

